/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.config;

import java.util.ArrayList;
import java.util.List;
import org.kaazing.gateway.management.config.ClusterConfigurationBean;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.service.cluster.ClusterConnectOptionsContext;
import org.kaazing.gateway.service.cluster.ClusterContext;
import org.kaazing.gateway.service.cluster.MemberId;

public class ClusterConfigurationBeanImpl
implements ClusterConfigurationBean {
    private final GatewayManagementBean gatewayBean;
    private final ClusterContext clusterContext;

    public ClusterConfigurationBeanImpl(ClusterContext clusterContext, GatewayManagementBean gatewayBean) {
        this.clusterContext = clusterContext;
        this.gatewayBean = gatewayBean;
    }

    @Override
    public GatewayManagementBean getGatewayManagementBean() {
        return this.gatewayBean;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public String getName() {
        return this.clusterContext.getClusterName();
    }

    @Override
    public List<String> getAccepts() {
        List accepts = this.clusterContext.getAccepts();
        ArrayList<String> acceptList = new ArrayList<String>();
        if (accepts != null && !accepts.isEmpty()) {
            for (MemberId member : accepts) {
                acceptList.add(member.getId());
            }
        }
        return acceptList;
    }

    @Override
    public List<String> getConnects() {
        List connects = this.clusterContext.getConnects();
        ArrayList<String> connectList = new ArrayList<String>();
        if (connects != null && !connects.isEmpty()) {
            for (MemberId member : connects) {
                connectList.add(member.getId());
            }
        }
        return connectList;
    }

    @Override
    public String getConnectOptions() {
        ClusterConnectOptionsContext connectOptions = this.clusterContext.getConnectOptions();
        if (connectOptions != null) {
            return connectOptions.getAwsAccessKeyId();
        }
        return "";
    }
}

