/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.update.check;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.kaazing.gateway.management.update.check.ManagementUpdateCheck;
import org.kaazing.gateway.management.update.check.ManagementUpdateCheckFactorySpi;

public final class ManagementUpdateCheckFactory {
    private final Map<String, ManagementUpdateCheckFactorySpi> factoriesByProtocol;

    private ManagementUpdateCheckFactory(Map<String, ManagementUpdateCheckFactorySpi> serviceFactoriesByType) {
        this.factoriesByProtocol = Collections.unmodifiableMap(serviceFactoriesByType);
    }

    public static ManagementUpdateCheckFactory newManagementUpdateCheckFactory() {
        return ManagementUpdateCheckFactory.newManagementUpdateCheckFactory(ServiceLoader.load(ManagementUpdateCheckFactorySpi.class));
    }

    public static ManagementUpdateCheckFactory newManagementUpdateCheckFactory(ClassLoader loader) {
        return ManagementUpdateCheckFactory.newManagementUpdateCheckFactory(ServiceLoader.load(ManagementUpdateCheckFactorySpi.class, loader));
    }

    public ManagementUpdateCheck newUpdateCheck(String protocol) {
        ManagementUpdateCheckFactorySpi managementUpdateCheckFactory = this.factoriesByProtocol.get(protocol);
        if (managementUpdateCheckFactory == null) {
            throw new IllegalArgumentException("Could not find factory for protocol: " + protocol);
        }
        return managementUpdateCheckFactory.newManagementUpdateCheck(protocol);
    }

    private static ManagementUpdateCheckFactory newManagementUpdateCheckFactory(ServiceLoader<ManagementUpdateCheckFactorySpi> serviceFactories) {
        ConcurrentHashMap<String, ManagementUpdateCheckFactorySpi> serviceFactoriesByType = new ConcurrentHashMap<String, ManagementUpdateCheckFactorySpi>();
        for (ManagementUpdateCheckFactorySpi managementUpdateCheckFactory : serviceFactories) {
            Collection<String> serviceTypes = managementUpdateCheckFactory.getSupportedProtocols();
            for (String protocol : serviceTypes) {
                ManagementUpdateCheckFactorySpi oldManagementUpdateCheckFactory = serviceFactoriesByType.putIfAbsent(protocol, managementUpdateCheckFactory);
                if (oldManagementUpdateCheckFactory == null) continue;
            }
        }
        return new ManagementUpdateCheckFactory(serviceFactoriesByType);
    }
}

