/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.monitoring.configuration.impl;

import java.io.File;
import org.kaazing.gateway.management.monitoring.configuration.MonitorFileWriter;
import org.kaazing.gateway.management.monitoring.configuration.MonitoringDataManager;
import org.kaazing.gateway.management.monitoring.configuration.impl.MonitorFileWriterImpl;
import org.kaazing.gateway.management.monitoring.entity.manager.impl.ServiceCounterManagerImpl;
import org.kaazing.gateway.management.monitoring.service.MonitoredService;
import org.kaazing.gateway.service.MonitoringEntityFactory;
import uk.co.real_logic.agrona.IoUtil;

public class MMFMonitoringDataManager
implements MonitoringDataManager {
    private static final String LINUX = "Linux";
    private static final String OS_NAME_SYSTEM_PROPERTY = "os.name";
    private static final String LINUX_DEV_SHM_DIRECTORY = "/dev/shm";
    private static final String MONITOR_DIR_NAME = "/kaazing";
    private MonitorFileWriter monitorFileWriter;
    private File monitoringDir;
    int serviceCount;
    private String gatewayId;

    public MMFMonitoringDataManager(String gatewayId) {
        this.gatewayId = gatewayId;
        this.monitorFileWriter = new MonitorFileWriterImpl(gatewayId);
    }

    @Override
    public MonitoringEntityFactory initialize() {
        this.createMonitoringFile();
        MonitoringEntityFactory gwCountersFactory = this.monitorFileWriter.getGatewayMonitoringEntityFactory();
        return gwCountersFactory;
    }

    @Override
    public ServiceCounterManagerImpl addService(MonitoredService monitoredService) {
        MonitoringEntityFactory serviceCountersFactory = this.monitorFileWriter.getServiceMonitoringEntityFactory(monitoredService, this.serviceCount);
        ++this.serviceCount;
        return new ServiceCounterManagerImpl(serviceCountersFactory);
    }

    @Override
    public void close() {
        this.monitorFileWriter.close(this.monitoringDir);
    }

    private void createMonitoringFile() {
        String monitoringDirName = this.getMonitoringDirName();
        this.monitoringDir = new File(monitoringDirName);
        File monitoringFile = new File(this.monitoringDir, this.gatewayId);
        IoUtil.deleteIfExists((File)monitoringFile);
        this.monitorFileWriter.initialize(monitoringFile);
    }

    private String getMonitoringDirName() {
        File devShmDir;
        String monitoringDirName = IoUtil.tmpDirName() + MONITOR_DIR_NAME;
        if (LINUX.equalsIgnoreCase(System.getProperty(OS_NAME_SYSTEM_PROPERTY)) && (devShmDir = new File(LINUX_DEV_SHM_DIRECTORY)).exists()) {
            monitoringDirName = LINUX_DEV_SHM_DIRECTORY + monitoringDirName;
        }
        return monitoringDirName;
    }
}

