/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.config;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kaazing.gateway.management.config.SecurityConfigurationBean;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.security.SecurityContext;

public class SecurityConfigurationBeanImpl
implements SecurityConfigurationBean {
    private final GatewayManagementBean gatewayBean;
    private final KeyStore keyStore;
    private final String keyStoreType;
    private final String keyStoreCertificateInfo;
    private final String trustStoreType;
    private final KeyStore trustStore;
    private final String trustStoreCertificateInfo;

    public SecurityConfigurationBeanImpl(SecurityContext context, GatewayManagementBean gatewayBean) {
        this.gatewayBean = gatewayBean;
        try {
            this.keyStore = context.getKeyStore();
            this.keyStoreType = this.keyStore == null ? null : this.keyStore.getType();
            this.keyStoreCertificateInfo = this.keyStore == null ? null : this.computeStoreCertificateInfo(this.keyStore);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            this.trustStore = context.getTrustStore();
            this.trustStoreType = this.trustStore == null ? null : this.trustStore.getType();
            this.trustStoreCertificateInfo = this.trustStore == null ? null : this.computeStoreCertificateInfo(this.trustStore);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public GatewayManagementBean getGatewayManagementBean() {
        return this.gatewayBean;
    }

    @Override
    public String getKeystoreType() {
        return this.nonNullString(this.keyStoreType);
    }

    @Override
    public String getKeystoreCertificateInfo() {
        return this.nonNullString(this.keyStoreCertificateInfo);
    }

    @Override
    public String getTruststoreType() {
        return this.nonNullString(this.trustStoreType);
    }

    @Override
    public String getTruststoreCertificateInfo() {
        return this.nonNullString(this.trustStoreCertificateInfo);
    }

    private String nonNullString(String value) {
        return value == null ? "" : value;
    }

    private String computeStoreCertificateInfo(KeyStore store) {
        JSONArray jsonArray = new JSONArray();
        try {
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!store.isCertificateEntry(alias)) continue;
                Certificate cert = store.getCertificate(alias);
                String type = null;
                PublicKey publicKey = null;
                if (cert != null) {
                    type = cert.getType();
                    publicKey = cert.getPublicKey();
                }
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("alias", (Object)alias);
                if (type != null) {
                    jsonObj.put("certificate-type", (Object)type);
                }
                if (cert instanceof X509Certificate) {
                    JSONArray issuerAlternativeNames;
                    X509Certificate x509Cert = (X509Certificate)cert;
                    jsonObj.put("version", x509Cert.getVersion());
                    try {
                        x509Cert.checkValidity(new Date());
                        jsonObj.put("valid", true);
                    }
                    catch (Exception ex) {
                        jsonObj.put("valid", false);
                    }
                    jsonObj.put("pathConstraint", x509Cert.getBasicConstraints());
                    Date d = x509Cert.getNotBefore();
                    jsonObj.put("notValidBefore", (Object)(d == null ? d : Long.valueOf(d.getTime())));
                    d = x509Cert.getNotAfter();
                    jsonObj.put("notValidAfter", (Object)(d == null ? d : Long.valueOf(d.getTime())));
                    jsonObj.put("serialNumber", (Object)x509Cert.getSerialNumber());
                    X500Principal issuer = x509Cert.getIssuerX500Principal();
                    jsonObj.put("issuer", (Object)issuer.getName());
                    X500Principal subject = x509Cert.getSubjectX500Principal();
                    jsonObj.put("subject", (Object)subject.getName());
                    JSONArray subjectAlternativeNames = this.getAlternativeNames(x509Cert.getSubjectAlternativeNames());
                    if (subjectAlternativeNames != null) {
                        jsonObj.put("subjectAlternativeNames", (Object)subjectAlternativeNames);
                    }
                    if ((issuerAlternativeNames = this.getAlternativeNames(x509Cert.getIssuerAlternativeNames())) != null) {
                        jsonObj.put("issuerAlternativeNames", (Object)issuerAlternativeNames);
                    }
                    jsonObj.put("signatureAlgorithm", (Object)x509Cert.getSigAlgName());
                }
                jsonArray.put((Object)jsonObj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonArray.toString();
    }

    private JSONArray getAlternativeNames(Collection<List<?>> alternativeNames) {
        if (alternativeNames == null || alternativeNames.size() == 0) {
            return null;
        }
        JSONArray altNames = new JSONArray();
        for (List<?> altName : alternativeNames) {
            String altNameValue = altName.get(1).toString();
            altNames.put((Object)altNameValue);
        }
        return altNames;
    }

    private String computeStoreHash(String storeFilePath) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        FileInputStream in = new FileInputStream(new File(storeFilePath));
        byte[] storeBytes = new byte[]{};
        int length = 1024;
        while (length == 1024) {
            byte[] b = new byte[1024];
            length = in.read(b);
            byte[] tmpStoreBytes = new byte[length + storeBytes.length];
            System.arraycopy(storeBytes, 0, tmpStoreBytes, 0, storeBytes.length);
            System.arraycopy(b, 0, tmpStoreBytes, storeBytes.length, length);
            storeBytes = tmpStoreBytes;
        }
        in.close();
        byte[] digestBytes = digest.digest(storeBytes);
        return new String(digestBytes);
    }
}

