/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.monitoring.configuration.impl;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import org.kaazing.gateway.management.monitoring.configuration.MonitorFileWriter;
import org.kaazing.gateway.management.monitoring.service.MonitoredService;
import org.kaazing.gateway.management.monitoring.writer.impl.MMFGatewayWriter;
import org.kaazing.gateway.management.monitoring.writer.impl.MMFServiceWriter;
import org.kaazing.gateway.service.MonitoringEntityFactory;
import uk.co.real_logic.agrona.BitUtil;
import uk.co.real_logic.agrona.IoUtil;
import uk.co.real_logic.agrona.concurrent.UnsafeBuffer;

public final class MonitorFileWriterImpl
implements MonitorFileWriter {
    private static final int OFFSETS_PER_SERVICE = 4;
    private static final int NUMBER_OF_INTS_PER_SERVICE = 5;
    private static final int NUMBER_OF_INTS_IN_HEADER = 8;
    private static final int SIZEOF_STRING = 128;
    private static final int SIZEOF_ENTRY = 128;
    private static final int ENTRIES_COUNT = 1024;
    private static final int MAX_SERVICE_COUNT = 100;
    private static final int MONITOR_VERSION = 1;
    private static final int MONITOR_VERSION_OFFSET = 0;
    private static final int GW_DATA_REFERENCE_OFFSET = 4;
    private static final int SERVICE_DATA_REFERENCE_OFFSET = 8;
    private static final int GW_ID_OFFSET = 12;
    private static final int GW_DATA_OFFSET = 12;
    private static final int GATEWAY_COUNTER_VALUES_BUFFER_LENGTH = 131072;
    private static final int GATEWAY_COUNTER_LABELS_BUFFER_LENGTH = 131072;
    private static final int SERVICE_COUNTER_VALUES_BUFFER_LENGTH = 131072;
    private static final int SERVICE_COUNTER_LABELS_BUFFER_LENGTH = 131072;
    private int gwCountersLblBuffersReferenceOffset;
    private int gwCountersLblBuffersLengthOffset;
    private int gwCountersValueBuffersReferenceOffset;
    private int gwCountersValueBuffersLengthOffset;
    private int noOfServicesOffset;
    private int serviceDataOffset;
    private int metadataLength;
    private int servicesCount;
    private int endOfMetadata;
    private int serviceRefSection;
    private UnsafeBuffer metaDataBuffer;
    private String gatewayId;
    private int prevServiceOffset;
    private String prevServiceName = "";
    private MappedByteBuffer mappedMonitorFile;

    public MonitorFileWriterImpl(String gatewayId) {
        this.gatewayId = gatewayId;
        this.setGatewayIdDependentOffsets(gatewayId);
        this.setServicesCount();
    }

    @Override
    public void initialize(File monitoringFile) {
        int fileSize = this.computeMonitorTotalFileLength();
        this.mappedMonitorFile = IoUtil.mapNewFile((File)monitoringFile, (long)fileSize);
        this.metaDataBuffer = new UnsafeBuffer((ByteBuffer)this.mappedMonitorFile, 0, this.metadataLength + 4);
        this.fillMetaData();
    }

    @Override
    public UnsafeBuffer createGatewayCounterLabelsBuffer() {
        int offset = this.endOfMetadata;
        int length = this.metaDataBuffer.getInt(this.gwCountersLblBuffersLengthOffset);
        this.metaDataBuffer.putInt(this.gwCountersLblBuffersReferenceOffset, offset);
        return new UnsafeBuffer((ByteBuffer)this.mappedMonitorFile, offset, length);
    }

    @Override
    public UnsafeBuffer createGatewayCounterValuesBuffer() {
        int offset = this.endOfMetadata + this.metaDataBuffer.getInt(this.gwCountersLblBuffersLengthOffset);
        int length = this.metaDataBuffer.getInt(this.gwCountersValueBuffersLengthOffset);
        this.metaDataBuffer.putInt(this.gwCountersValueBuffersReferenceOffset, offset);
        return new UnsafeBuffer((ByteBuffer)this.mappedMonitorFile, offset, length);
    }

    @Override
    public UnsafeBuffer createServiceCounterLabelsBuffer(int index) {
        int offset = this.endOfMetadata + this.metaDataBuffer.getInt(this.gwCountersLblBuffersLengthOffset) + this.metaDataBuffer.getInt(this.gwCountersValueBuffersLengthOffset) + index * 262144;
        int length = 131072;
        this.metaDataBuffer.putInt(this.serviceRefSection + index * 4 * 4, offset);
        return new UnsafeBuffer((ByteBuffer)this.mappedMonitorFile, offset, 131072);
    }

    @Override
    public UnsafeBuffer createServiceCounterValuesBuffer(int index) {
        int offset = this.endOfMetadata + this.metaDataBuffer.getInt(this.gwCountersLblBuffersLengthOffset) + this.metaDataBuffer.getInt(this.gwCountersValueBuffersLengthOffset) + index * 262144 + 131072;
        int length = 131072;
        this.metaDataBuffer.putInt(this.serviceRefSection + (index * 4 + 2) * 4, offset);
        return new UnsafeBuffer((ByteBuffer)this.mappedMonitorFile, offset, 131072);
    }

    @Override
    public MonitoringEntityFactory getGatewayMonitoringEntityFactory() {
        MMFGatewayWriter gatewayWriter = new MMFGatewayWriter(this);
        return gatewayWriter.writeCountersFactory();
    }

    @Override
    public MonitoringEntityFactory getServiceMonitoringEntityFactory(MonitoredService monitoredService, int index) {
        this.fillServiceMetadata(monitoredService.getServiceName(), index);
        MMFServiceWriter serviceWriter = new MMFServiceWriter(this, index);
        return serviceWriter.writeCountersFactory();
    }

    @Override
    public void close(File monitoringDir) {
        IoUtil.unmap((MappedByteBuffer)this.mappedMonitorFile);
        IoUtil.delete((File)monitoringDir, (boolean)false);
    }

    private void setServicesCount() {
        this.servicesCount = 100;
        this.metadataLength = 160 + this.servicesCount * 148;
        this.endOfMetadata = BitUtil.align((int)(this.metadataLength + 4), (int)64);
        this.serviceRefSection = this.endOfMetadata - this.servicesCount * 4 * 4;
    }

    private void fillMetaData() {
        this.metaDataBuffer.putInt(0, 1);
        this.metaDataBuffer.putInt(4, 12);
        this.metaDataBuffer.putInt(8, this.serviceDataOffset);
        this.metaDataBuffer.putStringUtf8(12, this.gatewayId, ByteOrder.nativeOrder());
        this.metaDataBuffer.putInt(this.gwCountersLblBuffersReferenceOffset, 0);
        this.metaDataBuffer.putInt(this.gwCountersLblBuffersLengthOffset, 131072);
        this.metaDataBuffer.putInt(this.gwCountersValueBuffersReferenceOffset, 0);
        this.metaDataBuffer.putInt(this.gwCountersValueBuffersLengthOffset, 131072);
        this.metaDataBuffer.putInt(this.noOfServicesOffset, 0);
    }

    private void fillServiceMetadata(String serviceName, int index) {
        int servAreaOffset = this.noOfServicesOffset + 4;
        this.metaDataBuffer.putInt(this.noOfServicesOffset, this.metaDataBuffer.getInt(this.noOfServicesOffset) + 1);
        int serviceNameOffset = this.getServiceNameOffset(servAreaOffset);
        int serviceLocationOffset = serviceNameOffset + serviceName.length() + 4;
        this.metaDataBuffer.putStringUtf8(serviceNameOffset, serviceName, ByteOrder.nativeOrder());
        this.initializeServiceRefMetadata(serviceLocationOffset, index * 4);
        this.prevServiceOffset = serviceNameOffset;
        this.prevServiceName = serviceName;
    }

    private int getServiceNameOffset(int servAreaOffset) {
        if (this.prevServiceOffset != 0) {
            return this.prevServiceOffset + this.prevServiceName.length() + 4 + 4;
        }
        return servAreaOffset;
    }

    private void initializeServiceRefMetadata(int serviceLocationOffset, int serviceOffsetIndex) {
        this.metaDataBuffer.putInt(serviceLocationOffset, this.serviceRefSection + serviceOffsetIndex * 4);
        this.metaDataBuffer.putInt(this.serviceRefSection + serviceOffsetIndex * 4, 0);
        this.metaDataBuffer.putInt(this.serviceRefSection + (serviceOffsetIndex + 1) * 4, 131072);
        this.metaDataBuffer.putInt(this.serviceRefSection + (serviceOffsetIndex + 2) * 4, 0);
        this.metaDataBuffer.putInt(this.serviceRefSection + (serviceOffsetIndex + 3) * 4, 131072);
    }

    private void setGatewayIdDependentOffsets(String gatewayId) {
        this.gwCountersLblBuffersReferenceOffset = 12 + gatewayId.length() + 4;
        this.gwCountersLblBuffersLengthOffset = this.gwCountersLblBuffersReferenceOffset + 4;
        this.gwCountersValueBuffersReferenceOffset = this.gwCountersLblBuffersLengthOffset + 4;
        this.gwCountersValueBuffersLengthOffset = this.gwCountersValueBuffersReferenceOffset + 4;
        this.serviceDataOffset = this.noOfServicesOffset = this.gwCountersValueBuffersLengthOffset + 4;
    }

    private int computeMonitorTotalFileLength() {
        int totalLengthOfBuffers = 26476544;
        return this.endOfMetadata + totalLengthOfBuffers;
    }
}

