/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.context;

import java.util.Properties;
import javax.annotation.Resource;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;
import org.kaazing.gateway.management.ManagementService;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.management.filter.ManagementFilter;
import org.kaazing.gateway.management.monitoring.configuration.MonitoringDataManager;
import org.kaazing.gateway.management.monitoring.configuration.impl.MonitoringDataManagerInjectorImpl;
import org.kaazing.gateway.management.monitoring.service.impl.MonitoredServiceImpl;
import org.kaazing.gateway.server.GatewayObserverFactorySpiPrototype;
import org.kaazing.gateway.server.context.GatewayContext;
import org.kaazing.gateway.service.MonitoringEntityFactory;
import org.kaazing.gateway.service.Service;
import org.kaazing.gateway.service.ServiceContext;
import org.kaazing.mina.core.session.IoSessionEx;

public class ManagementGatewayObserver
extends GatewayObserverFactorySpiPrototype {
    private ManagementContext managementContext;
    private Properties configuration;
    private MonitoringDataManager monitoringDataManager;

    @Resource(name="managementContext")
    public void setManagementContext(ManagementContext managementContext) {
        this.managementContext = managementContext;
    }

    @Resource(name="configuration")
    public void setConfiguration(Properties configuration) {
        this.configuration = configuration;
    }

    public void startingGateway(GatewayContext gatewayContext) {
        this.managementContext.createGatewayManagementBean();
        MonitoringDataManagerInjectorImpl injector = new MonitoringDataManagerInjectorImpl(this.configuration);
        this.monitoringDataManager = injector.makeMonitoringDataManager();
    }

    public void initingService(ServiceContext serviceContext) {
        MonitoringEntityFactory monitoringEntityFactory = this.monitoringDataManager.addService(new MonitoredServiceImpl(serviceContext));
        serviceContext.setMonitoringFactory(monitoringEntityFactory);
    }

    public void startingService(ServiceContext serviceContext) {
        if (!(serviceContext.getService() instanceof ManagementService)) {
            this.managementContext.addServiceManagementBean(serviceContext);
            this.addSessionInitializer(serviceContext.getService(), serviceContext);
        }
    }

    public void destroyedService(ServiceContext serviceContext) {
        serviceContext.getMonitoringFactory().close();
    }

    public void stoppedGateway(GatewayContext gatewayContext) {
        this.monitoringDataManager.close();
    }

    private void addSessionInitializer(Service service, ServiceContext serviceContext) {
        if (!(service instanceof ManagementService)) {
            final IoSessionInitializer parentInitializer = serviceContext.getSessionInitializor();
            final ManagementFilter managementFilter = this.managementContext.getManagementFilter(serviceContext);
            serviceContext.setSessionInitializor((IoSessionInitializer)new IoSessionInitializer<ConnectFuture>(){
                public static final String MANAGEMENT_FILTER_NAME = "management";

                public void initializeSession(IoSession session, ConnectFuture future) {
                    if (!session.getFilterChain().contains(MANAGEMENT_FILTER_NAME)) {
                        try {
                            managementFilter.newManagementSession((IoSessionEx)session);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException("Exception adding new management session for session: " + session, ex);
                        }
                        session.getFilterChain().addLast(MANAGEMENT_FILTER_NAME, (IoFilter)managementFilter);
                        if (parentInitializer != null) {
                            parentInitializer.initializeSession(session, (IoFuture)future);
                        }
                    }
                }
            });
        }
    }
}

