/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.system;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import org.hyperic.sigar.SigarException;
import org.json.JSONException;
import org.json.JSONObject;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.management.system.AbstractSystemManagementBean;
import org.kaazing.gateway.management.system.JvmManagementBean;

public class JvmManagementBeanImpl
extends AbstractSystemManagementBean
implements JvmManagementBean {
    private final GatewayManagementBean gatewayManagementBean;
    private long classesLoaded;
    private long totalClassesLoaded;
    private long totalClassesUnloaded;
    private long memHeapInitSize;
    private long memHeapUsed;
    private long memHeapCommitted;
    private long memHeapMaxSize;
    private long memNonHeapInitSize;
    private long memNonHeapUsed;
    private long memNonHeapCommitted;
    private long memNonHeapMaxSize;
    private long threadingLiveThreads;
    private long threadingPeakThreads;
    private long threadingTotalThreads;

    public JvmManagementBeanImpl(GatewayManagementBean gatewayManagementBean, int summaryDataLimit) {
        super(gatewayManagementBean.getManagementContext(), gatewayManagementBean.getManagementContext().getSystemSummaryDataNotificationInterval(), JvmManagementBean.SUMMARY_DATA_FIELD_LIST, gatewayManagementBean.getManagementContext().getJvmSummaryDataGatherInterval(), "JVM stats", summaryDataLimit, "SNMPJvmSummaryData");
        this.gatewayManagementBean = gatewayManagementBean;
    }

    @Override
    public void init() {
    }

    @Override
    public GatewayManagementBean getGatewayManagementBean() {
        return this.gatewayManagementBean;
    }

    @Override
    public void doGatherStats(JSONObject jsonObj, long readTime) throws SigarException, JSONException {
        ClassLoadingMXBean classLoadingBean = ManagementFactory.getClassLoadingMXBean();
        this.classesLoaded = classLoadingBean.getLoadedClassCount();
        this.totalClassesLoaded = classLoadingBean.getTotalLoadedClassCount();
        this.totalClassesUnloaded = classLoadingBean.getUnloadedClassCount();
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryBean.getHeapMemoryUsage();
        this.memHeapInitSize = memoryUsage.getInit();
        this.memHeapUsed = memoryUsage.getUsed();
        this.memHeapCommitted = memoryUsage.getCommitted();
        this.memHeapMaxSize = memoryUsage.getMax();
        memoryUsage = memoryBean.getNonHeapMemoryUsage();
        this.memNonHeapInitSize = memoryUsage.getInit();
        this.memNonHeapUsed = memoryUsage.getUsed();
        this.memNonHeapCommitted = memoryUsage.getCommitted();
        this.memNonHeapMaxSize = memoryUsage.getMax();
        ThreadMXBean threadingBean = ManagementFactory.getThreadMXBean();
        this.threadingLiveThreads = threadingBean.getThreadCount();
        this.threadingPeakThreads = threadingBean.getPeakThreadCount();
        this.threadingTotalThreads = threadingBean.getTotalStartedThreadCount();
        Number[] vals = new Number[this.summaryDataFieldList.length];
        vals[0] = this.classesLoaded;
        vals[1] = this.totalClassesLoaded;
        vals[2] = this.totalClassesUnloaded;
        vals[3] = this.memHeapInitSize;
        vals[4] = this.memHeapUsed;
        vals[5] = this.memHeapCommitted;
        vals[6] = this.memHeapMaxSize;
        vals[7] = this.memNonHeapInitSize;
        vals[8] = this.memNonHeapUsed;
        vals[9] = this.memNonHeapCommitted;
        vals[10] = this.memNonHeapMaxSize;
        vals[11] = this.threadingLiveThreads;
        vals[12] = this.threadingPeakThreads;
        vals[13] = this.threadingTotalThreads;
        jsonObj.put("jvmData", (Object)vals);
    }
}

