/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kaazing.gateway.management.ManagementBean;
import org.kaazing.gateway.management.SummaryDataListener;
import org.kaazing.gateway.management.SummaryManagementInterval;
import org.kaazing.gateway.management.Utils;
import org.kaazing.gateway.management.context.ManagementContext;
import org.kaazing.gateway.util.scheduler.SchedulerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractManagementBean
implements ManagementBean {
    private static final Logger logger = LoggerFactory.getLogger(AbstractManagementBean.class);
    protected final List<SummaryDataListener> summaryDataListeners;
    protected final ManagementContext managementContext;
    protected final SummaryManagementInterval summaryInterval;
    protected final String[] summaryDataFieldList;
    protected String summaryDataFields;
    private SchedulerProvider schedulerProvider;
    private ScheduledExecutorService summaryDataScheduler;
    private final AtomicBoolean dirty = new AtomicBoolean(true);
    private ScheduledFuture<Boolean> summaryDataFuture;

    public AbstractManagementBean(ManagementContext managementContext, SummaryManagementInterval summaryInterval, String[] summaryDataFieldList) {
        this.managementContext = managementContext;
        this.summaryInterval = summaryInterval;
        this.summaryDataFieldList = summaryDataFieldList;
        this.summaryDataListeners = new ArrayList<SummaryDataListener>();
    }

    protected SchedulerProvider getSchedulerProvider() {
        if (this.schedulerProvider == null) {
            this.schedulerProvider = this.managementContext.getSchedulerProvider();
        }
        return this.schedulerProvider;
    }

    protected ScheduledExecutorService getSummaryDataScheduler() {
        if (this.summaryDataScheduler == null) {
            this.getSchedulerProvider();
            this.summaryDataScheduler = this.schedulerProvider.getScheduler("summaryData", false);
        }
        return this.summaryDataScheduler;
    }

    @Override
    public String getSummaryDataFields() {
        if (this.summaryDataFields == null) {
            this.summaryDataFields = Utils.makeJSONArrayString(this.summaryDataFieldList);
        }
        return this.summaryDataFields;
    }

    @Override
    public abstract String getSummaryData();

    @Override
    public List<SummaryDataListener> getSummaryDataListeners() {
        return this.summaryDataListeners;
    }

    @Override
    public void addSummaryDataListener(SummaryDataListener summaryDataListener) {
        this.summaryDataListeners.add(summaryDataListener);
    }

    @Override
    public void removeSummaryDataListener(SummaryDataListener summaryDataListener) {
        this.summaryDataListeners.remove(summaryDataListener);
    }

    @Override
    public SummaryManagementInterval getSummaryInterval() {
        return this.summaryInterval;
    }

    @Override
    public boolean isDirty() {
        return this.dirty.get();
    }

    @Override
    public ManagementContext getManagementContext() {
        return this.managementContext;
    }

    @Override
    public void runManagementTask(Runnable runnable) {
        this.managementContext.runManagementTask(runnable);
    }

    protected void markChanged() {
        this.setDirty();
        if (this.summaryDataFuture == null || this.summaryDataFuture.isDone()) {
            this.sendSummaryData();
        }
    }

    private void setDirty() {
        this.dirty.compareAndSet(false, true);
    }

    private boolean clearDirty() {
        boolean val = this.dirty.compareAndSet(true, false);
        return val;
    }

    public boolean sendSummaryData() {
        if (this.clearDirty()) {
            String summaryData = this.getSummaryData();
            for (SummaryDataListener listener : this.summaryDataListeners) {
                listener.sendSummaryData(summaryData);
            }
            this.scheduleSummaryData();
            return true;
        }
        return false;
    }

    private void scheduleSummaryData() {
        this.summaryDataFuture = this.getSummaryDataScheduler().schedule(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return AbstractManagementBean.this.sendSummaryData();
            }
        }, (long)this.summaryInterval.getInterval(), TimeUnit.MILLISECONDS);
    }
}

