/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.system;

import org.json.JSONObject;
import org.kaazing.gateway.management.system.NicManagementBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NicManagementBeanImpl
implements NicManagementBean {
    public static final int ROUND_TO_PLACES = 4;
    private final int id;
    private final String interfaceName;
    private Long[] netInterfaceStats;
    private double rxBytesPerSecond;
    private double txBytesPerSecond;
    private long updateTimeMillis = -1L;
    private static final Logger logger = LoggerFactory.getLogger(NicManagementBeanImpl.class);

    public static double roundTo(double val, int places) {
        long temp = (long)(val * Math.pow(10.0, places));
        return (double)temp / Math.pow(10.0, places);
    }

    public NicManagementBeanImpl(int id, String interfaceName) {
        this.id = id;
        this.interfaceName = interfaceName;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.interfaceName;
    }

    @Override
    public long getRxBytes() {
        return this.netInterfaceStats[0];
    }

    @Override
    public double getRxBytesPerSecond() {
        return this.rxBytesPerSecond;
    }

    @Override
    public long getRxDropped() {
        return this.netInterfaceStats[1];
    }

    @Override
    public long getRxErrors() {
        return this.netInterfaceStats[2];
    }

    @Override
    public long getTxBytes() {
        return this.netInterfaceStats[3];
    }

    @Override
    public double getTxBytesPerSecond() {
        return this.txBytesPerSecond;
    }

    @Override
    public long getTxDropped() {
        return this.netInterfaceStats[4];
    }

    @Override
    public long getTxErrors() {
        return this.netInterfaceStats[5];
    }

    @Override
    public void update(Long[] netInterfaceStats, long updateTimeMillis) {
        if (this.updateTimeMillis > 0L) {
            long deltaMillis = updateTimeMillis - this.updateTimeMillis;
            long deltaRxBytes = netInterfaceStats[0] - this.getRxBytes();
            this.rxBytesPerSecond = (double)deltaRxBytes * 1000.0 / (double)deltaMillis;
            long deltaTxBytes = netInterfaceStats[3] - this.getTxBytes();
            this.txBytesPerSecond = (double)deltaTxBytes * 1000.0 / (double)deltaMillis;
        }
        this.netInterfaceStats = netInterfaceStats;
        this.updateTimeMillis = updateTimeMillis;
    }

    @Override
    public String getSummaryData() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put(SUMMARY_DATA_FIELD_LIST[0], this.getRxBytes());
            jsonObj.put(SUMMARY_DATA_FIELD_LIST[1], NicManagementBeanImpl.roundTo(this.getRxBytesPerSecond(), 4));
            jsonObj.put(SUMMARY_DATA_FIELD_LIST[2], this.getRxDropped());
            jsonObj.put(SUMMARY_DATA_FIELD_LIST[3], this.getRxErrors());
            jsonObj.put(SUMMARY_DATA_FIELD_LIST[4], this.getTxBytes());
            jsonObj.put(SUMMARY_DATA_FIELD_LIST[5], NicManagementBeanImpl.roundTo(this.getTxBytesPerSecond(), 4));
            jsonObj.put(SUMMARY_DATA_FIELD_LIST[6], this.getTxDropped());
            jsonObj.put(SUMMARY_DATA_FIELD_LIST[7], this.getTxErrors());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonObj.toString();
    }

    @Override
    public Object[] getSummaryDataValues() {
        Object[] vals = new Object[SUMMARY_DATA_FIELD_LIST.length];
        vals[0] = this.getRxBytes();
        vals[1] = NicManagementBeanImpl.roundTo(this.getRxBytesPerSecond(), 4);
        vals[2] = this.getRxDropped();
        vals[3] = this.getRxErrors();
        vals[4] = this.getTxBytes();
        vals[5] = NicManagementBeanImpl.roundTo(this.getTxBytesPerSecond(), 4);
        vals[6] = this.getTxDropped();
        vals[7] = this.getTxErrors();
        return vals;
    }
}

