/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup.handler;

import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import stream.CopiesUtils;
import stream.Copy;
import stream.app.ComputeGraph;
import stream.io.Source;
import stream.io.Stream;
import stream.runtime.DependencyInjection;
import stream.runtime.ElementHandler;
import stream.runtime.ProcessContainer;
import stream.runtime.setup.factory.ObjectFactory;
import stream.runtime.setup.factory.ProcessorFactory;
import stream.runtime.setup.factory.StreamFactory;
import stream.service.Service;
import stream.util.Variables;

public class StreamElementHandler
implements ElementHandler {
    static Logger log = LoggerFactory.getLogger(StreamElementHandler.class);
    final ObjectFactory objectFactory;
    final ProcessorFactory processorFactory;

    public StreamElementHandler(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
        this.processorFactory = new ProcessorFactory(objectFactory);
    }

    @Override
    public String getKey() {
        return "Stream";
    }

    @Override
    public boolean handlesElement(Element element) {
        if (element == null) {
            return false;
        }
        return "Stream".equalsIgnoreCase(element.getNodeName()) || "DataStream".equalsIgnoreCase(element.getNodeName());
    }

    @Override
    public void handleElement(ProcessContainer container, Element element, Variables variables, DependencyInjection dependencyInjection) throws Exception {
        try {
            ComputeGraph computeGraph = container.computeGraph();
            Map<String, String> attr = this.objectFactory.getAttributes(element);
            String id = attr.get("id");
            List<Object> cp = new ArrayList();
            String copies = element.getAttribute("copies");
            log.debug("found 'copies' attribute, value is: '{}'", (Object)copies);
            if (copies == null || copies.trim().isEmpty()) {
                log.debug("Processing single-stream (no copies)");
                id = variables.expand(id);
                Copy c = new Copy();
                c.setId(id);
                cp.add(c);
            } else {
                log.debug("Processing multiple copies of the stream element...");
                copies = variables.expand(copies);
                cp = Arrays.asList(CopiesUtils.parse((String)copies));
            }
            for (Copy copy : cp) {
                log.debug("Creating stream for copy '{}'", (Object)copy.getId());
                Variables local = new Variables(variables);
                CopiesUtils.addCopyIds((Variables)local, (Copy)copy);
                String lid = local.expand(id);
                Stream stream = StreamFactory.createStream(this.objectFactory, element, local);
                if (stream != null) {
                    if (lid == null) {
                        lid = "" + stream;
                    }
                    stream.setId(lid);
                    try {
                        Method m = stream.getClass().getMethod("read", null);
                        int mod = m.getModifiers();
                        if (!Modifier.isSynchronized(mod)) {
                            log.warn("DANGER: Use of non-synchronized read() method in stream implementation!");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    computeGraph.addStream(lid, stream);
                    container.registerStream(lid, (Source)stream);
                }
                if (!(stream instanceof Service)) continue;
                container.getContext().register(lid, (Service)stream);
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new Exception("Cannot create stream from referenced file: " + fnfe.getMessage());
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                throw new Exception(e.getCause());
            }
            log.error("Failed to create stream-object: {}", (Object)e.getMessage());
            e.printStackTrace();
            throw new Exception("Failed to create data-stream: " + e.getMessage());
        }
    }
}

