/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup.handler;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import stream.CopiesUtils;
import stream.Copy;
import stream.app.ComputeGraph;
import stream.io.Queue;
import stream.runtime.DependencyInjection;
import stream.runtime.ElementHandler;
import stream.runtime.ProcessContainer;
import stream.runtime.setup.factory.ObjectFactory;
import stream.service.Service;
import stream.util.Variables;

public class QueueElementHandler
implements ElementHandler {
    static Logger log = LoggerFactory.getLogger(QueueElementHandler.class);
    static final String DEFAULT_QUEUE_IMPL = "stream.io.DefaultBlockingQueue";

    @Override
    public String getKey() {
        return "Queue";
    }

    @Override
    public boolean handlesElement(Element element) {
        return this.getKey().equalsIgnoreCase(element.getNodeName());
    }

    @Override
    public void handleElement(ProcessContainer container, Element element, Variables variables, DependencyInjection dependencyInjection) throws Exception {
        String id;
        Map<String, String> params;
        ComputeGraph computeGraph = container.computeGraph();
        String className = element.getAttribute("class");
        if (className == null || className.trim().isEmpty()) {
            className = DEFAULT_QUEUE_IMPL;
        }
        if (!(params = container.getObjectFactory().getAttributes(element)).containsKey("class")) {
            params.put("class", DEFAULT_QUEUE_IMPL);
        }
        if ((id = element.getAttribute("id")) == null || id.trim().isEmpty()) {
            throw new Exception("No 'id' attribute defined for queue!");
        }
        String copiesString = element.getAttribute("copies");
        Copy[] copies = null;
        if (copiesString != null && !copiesString.isEmpty()) {
            copiesString = variables.expand(copiesString);
            copies = CopiesUtils.parse((String)copiesString);
        } else {
            Copy c = new Copy();
            c.setId(id);
            copies = new Copy[]{c};
        }
        if (copies == null) {
            log.info("queues where not created, due to 'zero' copies");
            return;
        }
        for (Copy copy : copies) {
            Variables local = new Variables(variables);
            CopiesUtils.addCopyIds((Variables)local, (Copy)copy);
            String cid = local.expand(id);
            Queue queue = (Queue)container.getObjectFactory().create(className, params, ObjectFactory.createConfigDocument(element), local);
            container.registerQueue(copy.getId(), queue, true);
            computeGraph.addQueue(cid, queue);
            if (!(queue instanceof Service)) continue;
            container.getContext().register(cid, (Service)queue);
            computeGraph.addService(cid, (Service)queue);
        }
    }
}

