/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.app.ComputeGraph;
import stream.runtime.ContainerContext;
import stream.runtime.ServiceReference;
import stream.service.Service;
import stream.util.Variables;

public class ServiceInjection {
    static Logger log = LoggerFactory.getLogger(ServiceInjection.class);

    public static void injectServices(Collection<ServiceReference> refs, ContainerContext ctx, ComputeGraph graph, Variables variables) throws Exception {
        for (ServiceReference ref : refs) {
            log.debug("Checking service-reference {}", (Object)ref);
            String serviceRef = variables.expand(ref.getRef());
            Object consumer = ref.getReceiver();
            if (serviceRef.contains(",")) {
                String[] serviceRefs = serviceRef.split(",");
                for (int i = 0; i < serviceRefs.length; ++i) {
                    serviceRefs[i] = serviceRefs[i].trim();
                }
                Object services = Array.newInstance(ref.getServiceClass().getComponentType(), serviceRefs.length);
                for (int i = 0; i < serviceRefs.length; ++i) {
                    Object serv = ctx.lookup(serviceRefs[i], ref.getServiceClass());
                    log.debug("Found service {}", serv);
                    Class<?> sc = ref.getServiceClass().getComponentType();
                    log.debug("Casting to {}", ref.getServiceClass().getComponentType());
                    Array.set(services, i, serv);
                    graph.add(consumer, serv);
                    log.debug("Adding service for {}", (Object)serviceRefs[i]);
                }
                Method m = ServiceInjection.getServiceSetter(consumer, ref.getProperty(), true);
                if (m != null) {
                    log.debug("Injecting service-array {} into consumer {}", services, consumer);
                    log.info("Invoking method {}", (Object)m);
                    Object[] args = new Object[]{services};
                    log.debug("arguments: {}", args);
                    log.debug("Starting invocation on {}", consumer);
                    m.invoke(consumer, args);
                    continue;
                }
                throw new Exception("No service-setter found for service-array " + services + " in object" + consumer);
            }
            Object service = ctx.lookup(serviceRef, ref.getServiceClass());
            if (service == null) {
                throw new Exception("No service could be injected for reference '" + serviceRef + "' - no service registered for that id?!");
            }
            log.debug("Found service of class {} for reference '{}'", service.getClass(), (Object)serviceRef);
            Method m = ServiceInjection.getServiceSetter(consumer, ref.getProperty(), false);
            if (m != null) {
                log.debug("Injecting service {} into consumer {}", service, consumer);
                log.debug("Method for injection is {}", (Object)m);
                graph.add(consumer, service);
                m.invoke(consumer, service);
                continue;
            }
            throw new Exception("Failed to lookup service-setter for " + consumer + " " + ref.getProperty());
        }
    }

    public static Class<? extends Service> hasServiceSetter(String name, Object o) {
        try {
            for (Method m : o.getClass().getMethods()) {
                if (!m.getName().equalsIgnoreCase("set" + name) || !ServiceInjection.isServiceSetter(m)) continue;
                return m.getParameterTypes()[0];
            }
            return null;
        }
        catch (Exception e) {
            log.error("Failed to determine service-setter: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static Method getServiceSetter(Object o, String serviceRefName, boolean array) {
        String serviceName = serviceRefName.replaceAll("-ref$", "");
        for (Method m : o.getClass().getMethods()) {
            if (!m.getName().toLowerCase().equals("set" + serviceName.toLowerCase())) continue;
            log.debug("Found setter  {}(..)  for serviceRefName {}", (Object)m.getName(), (Object)serviceRefName);
            Class<?>[] types = m.getParameterTypes();
            if (types.length != 1) {
                log.debug("Skipping method {} as it does require a *single* parameter!", (Object)m.getName());
                continue;
            }
            Class<?> type = types[0];
            if (!ServiceInjection.isServiceImplementation(type) || array && (!array || !type.isArray())) continue;
            return m;
        }
        return null;
    }

    public static boolean isServiceSetter(Method m) {
        if (!m.getName().startsWith("set")) {
            return false;
        }
        Class<?>[] paramTypes = m.getParameterTypes();
        if (paramTypes.length != 1) {
            return false;
        }
        return ServiceInjection.isServiceImplementation(paramTypes[0]);
    }

    public static boolean isServiceImplementation(Class<?> clazz) {
        if (clazz == Service.class) {
            return true;
        }
        if (clazz.isArray()) {
            log.debug("checking array component-type for service implementation");
            return ServiceInjection.isServiceImplementation(clazz.getComponentType());
        }
        if (Service.class.isAssignableFrom(clazz)) {
            return true;
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            log.trace("Checking if {} = {}", intf, Service.class);
            if (!intf.equals(Service.class) && intf != Service.class) continue;
            log.trace("Yes, class {} implements the service interface!", clazz);
            return true;
        }
        log.trace("No, class {} does not implement the service interface!", clazz);
        return false;
    }
}

