/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.annotations.Parameter;
import stream.annotations.ParameterException;
import stream.runtime.setup.ParameterMethodInjection;

public class ParameterValidator {
    static Logger log = LoggerFactory.getLogger(ParameterValidator.class);

    public static boolean check(Object o, Map<String, Object> vals) throws ParameterException {
        Map<String, Class<?>> types = ParameterValidator.checkClassParameters(o.getClass());
        log.info("Object {} has {} paramters: {}", new Object[]{o, types.size(), types});
        return false;
    }

    public static Map<String, Class<?>> checkClassParameters(Class<?> clazz) throws ParameterException {
        Method[] methods;
        Field[] fields;
        LinkedHashMap params = new LinkedHashMap();
        for (Field field : fields = clazz.getDeclaredFields()) {
            Parameter info = field.getAnnotation(Parameter.class);
            if (info == null) continue;
            String name = info.name();
            if (name == null || name.isEmpty()) {
                name = field.getName();
            }
            log.info("Found parameter '{}' for field '{}'", (Object)name, (Object)field.getName());
            params.put(name, field.getType());
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            String name;
            Parameter p = method.getAnnotation(Parameter.class);
            if (p == null || (name = ParameterMethodInjection.getParameterName(method)) == null) continue;
            if (params.containsKey(name) && p != null) {
                throw new ParameterException("Parameter '" + name + "' already defined by field annotation!");
            }
            params.put(name, method.getParameterTypes()[0]);
        }
        return params;
    }
}

