/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.annotations.Parameter;
import stream.annotations.ParameterException;
import stream.runtime.setup.ParameterValueMapper;
import stream.util.Variables;

public class ParameterFieldInjection
extends ParameterValueMapper {
    static Logger log = LoggerFactory.getLogger(ParameterFieldInjection.class);

    public Set<String> inject(final Object o, Map<String, ?> params, Variables context) throws ParameterException {
        Field[] fields;
        HashSet<String> injected = new HashSet<String>();
        for (final Field field : fields = o.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Parameter.class)) {
                log.debug("Skipping field '{}' without parameter annoation...", (Object)field.getName());
                continue;
            }
            boolean accessLevel = field.isAccessible();
            field.setAccessible(true);
            Parameter p = field.getAnnotation(Parameter.class);
            String name = p.name();
            log.info("Found parameter annotation with name '{}' for field '{}'", (Object)name, (Object)field.getName());
            if (name == null || name.isEmpty()) {
                log.info("Parameter annotation for field '{}' has no name, using field name.", (Object)field.getName());
                name = field.getName();
            } else {
                log.info("Using property '{}' as defined by annotation, instead of field name '{}'", (Object)p.name(), (Object)field.getName());
            }
            if (p.required() && !params.containsKey(name)) {
                log.error("Parameter '{}' is required, but no value is provided for it!", (Object)name);
                throw new ParameterException("Missing value for required parameter '" + name + "'!");
            }
            Object value = params.get(name);
            Object set = null;
            if (value != null) {
                log.debug("Object for key '{}' is: {}", (Object)name, value);
                final Object po = this.createValue(field.getType(), value);
                set = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            field.set(o, po);
                            return po;
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }
                });
            } else {
                log.info("Leaving option field '{}' with no parameter value given untouched.", (Object)field.getName());
            }
            if (set != null) {
                log.debug("Successfully injected value for parameter '{}'", (Object)name);
                injected.add(name);
            } else {
                log.warn("Failed to set value for parameter '{}' using field-injection", (Object)name);
            }
            field.setAccessible(accessLevel);
        }
        return injected;
    }
}

