/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.rpc;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteClassServer
extends Thread {
    static Logger log = LoggerFactory.getLogger(RemoteClassServer.class);
    ServerSocket socket;

    public RemoteClassServer() throws Exception {
        this(0);
    }

    public RemoteClassServer(int port) throws Exception {
        this.socket = new ServerSocket(port);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket client = this.socket.accept();
                    log.info("creating handler for client {}", (Object)(client.getInetAddress().getHostAddress() + ":" + client.getPort()));
                    RequestHandler handler = new RequestHandler(client);
                    handler.start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static byte[] readResource(String path) throws Exception {
        byte[] bytes = new byte[65536];
        int off = 0;
        int total = 0;
        URL url = RemoteClassServer.class.getResource(path);
        System.out.println("URL: " + url);
        if (url != null) {
            InputStream source = url.openStream();
            int read = 0;
            do {
                read = source.read(bytes, off, 4096);
                System.out.println(read + " bytes read.");
                if (read <= 0) continue;
                off += read;
                total += read;
            } while (read > 0);
            source.close();
            ByteBuffer buffer = ByteBuffer.allocate(total);
            buffer.put(bytes, 0, total);
            return buffer.array();
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        byte[] data = RemoteClassServer.readResource("/stream/data/Data.class");
        System.out.println("data: " + data + " (" + data.length + " bytes)");
    }

    public class RequestHandler
    extends Thread {
        Logger log = LoggerFactory.getLogger(RequestHandler.class);
        Socket socket;

        public RequestHandler(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
                StringBuffer header = new StringBuffer();
                String line = reader.readLine();
                String[] req = line.split("\\s+");
                String resource = req[1];
                while (line != null && !line.trim().isEmpty()) {
                    if (line.indexOf(":") > 0) {
                        String[] tok = line.split(":", 2);
                        headers.put(tok[0].trim(), tok[1].trim());
                    }
                    header.append(line + "\n");
                    line = reader.readLine();
                }
                this.log.info("header:\n{}", (Object)header);
                URL url = RemoteClassServer.class.getResource(resource);
                this.log.info("Resource {} is at {}", (Object)resource, (Object)url);
                byte[] data = RemoteClassServer.readResource(resource);
                OutputStream rawOut = this.socket.getOutputStream();
                PrintWriter out = new PrintWriter(rawOut);
                if (data != null) {
                    this.log.info("{} bytes read", (Object)data.length);
                    out.print("HTTP/1.0 200 OK\r\n");
                    out.print("Content-Length: " + data.length + "\r\n");
                    out.print("Content-Type: text/html\r\n\r\n");
                    out.flush();
                    rawOut.write(data);
                    rawOut.flush();
                    this.log.info("{} bytes sent", (Object)data.length);
                    rawOut.flush();
                    rawOut.close();
                } else {
                    out.print("HTTP 404 Not Found\r\n\r\n");
                    out.flush();
                }
                this.socket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

