/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.rpc;

import java.io.Serializable;
import java.nio.charset.Charset;

public final class ContainerAnnouncement
implements Serializable {
    private static final long serialVersionUID = -6722120641397620906L;
    public static final byte[] CONTAINER_QUERY = "Where are my little stream-containers?!".getBytes();
    final String name;
    final String protocol;
    final String host;
    final Integer port;

    public ContainerAnnouncement(String name, String protocol, String host, Integer port) {
        this.name = name;
        this.protocol = protocol;
        this.host = host;
        this.port = port;
    }

    public ContainerAnnouncement(byte[] array) {
        String str = new String(array, Charset.forName("UTF-8")).trim();
        String[] tok = str.split("\\|");
        this.name = tok[0];
        this.protocol = tok[1];
        this.host = tok[2];
        this.port = new Integer(tok[3]);
    }

    public String getName() {
        return this.name;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public byte[] toByteArray() {
        return (this.name + "|" + this.protocol + "|" + this.host + "|" + this.port).getBytes(Charset.forName("UTF-8"));
    }

    public String toString() {
        return this.name + "|" + this.protocol + "|" + this.host + "|" + this.port;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o != null && this.toString().equals(o.toString());
    }
}

