/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.rpc;

import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.runtime.rpc.ContainerAnnouncement;

public class Announcer
extends Thread {
    static Logger log = LoggerFactory.getLogger(Announcer.class);
    boolean running = true;
    final Map<String, Long> alive = new LinkedHashMap<String, Long>();
    final MulticastSocket broadcast;
    Long interval = 1000L;
    final ContainerAnnouncement announcement;

    public Announcer(int port, ContainerAnnouncement announcement) throws Exception {
        this.setDaemon(true);
        this.broadcast = new MulticastSocket(port);
        this.broadcast.setBroadcast(true);
        this.announcement = announcement;
    }

    @Override
    public void run() {
        byte[] data = this.announcement.toByteArray();
        int len = data.length;
        while (this.running) {
            try {
                log.debug("Waiting for container queries to {}:{}", (Object)this.broadcast.getLocalAddress(), (Object)this.broadcast.getLocalPort());
                DatagramPacket query = new DatagramPacket(ContainerAnnouncement.CONTAINER_QUERY, ContainerAnnouncement.CONTAINER_QUERY.length);
                this.broadcast.receive(query);
                if (this.running) {
                    DatagramPacket p = new DatagramPacket(data, len);
                    log.debug("Sending response to {}:{}", (Object)query.getAddress(), (Object)query.getPort());
                    p.setAddress(query.getAddress());
                    p.setPort(query.getPort());
                    this.broadcast.send(p);
                    log.debug("Sent '" + new String(p.getData()) + "' to broadcast...");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                log.debug("Sleeping for " + this.interval + "ms");
                Thread.sleep(this.interval);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void finish() {
        this.running = false;
    }
}

