/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.dependencies;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.runtime.dependencies.Dependency;
import stream.util.XMLUtils;

public class DependencyResolver {
    static Logger log = LoggerFactory.getLogger(DependencyResolver.class);
    final List<String> baseUrls = new ArrayList<String>();
    final Set<URL> classPathUrls = new LinkedHashSet<URL>();
    String localRepo = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository" + File.separator;
    final Set<Dependency> resolvedDependencies = new LinkedHashSet<Dependency>();
    final Set<String> scopes = new HashSet<String>();

    public DependencyResolver() {
        if (System.getenv("STREAMS_REPOSITORY") != null && !"".equals(System.getenv("STREAMS_REPOSITORY").trim())) {
            this.localRepo = System.getenv("STREAMS_REPOSITORY");
            log.debug("Using local repository {}", (Object)this.localRepo);
        }
        this.baseUrls.add("http://repo.maven.apache.org/maven2/");
        this.scopes.add("compile");
        this.scopes.add("provided");
    }

    public Set<URL> getClasspathURLs() {
        return Collections.unmodifiableSet(this.classPathUrls);
    }

    public Set<Dependency> resolve(Dependency dep) throws Exception {
        HashSet<Dependency> toResolve = new HashSet<Dependency>();
        toResolve.add(dep);
        while (!toResolve.isEmpty()) {
            log.debug("{} dependency left to resolve", (Object)toResolve.size());
            Iterator it = toResolve.iterator();
            Dependency cur = (Dependency)it.next();
            it.remove();
            if (this.resolvedDependencies.contains(cur)) continue;
            this.resolvedDependencies.add(cur);
            boolean found = false;
            for (String base : this.baseUrls) {
                try {
                    String sel;
                    if (base.startsWith("/")) {
                        base = "file:" + base;
                    }
                    List<String> versions = this.extractVersions(cur);
                    log.debug("Versions found for {}: {}", (Object)cur.artifactId, versions);
                    cur.version = sel = this.selectVersion(versions, cur.version);
                    log.debug("Checking for {}", (Object)cur);
                    Set<Dependency> trans = this.extractDependenciesFromPom(base, cur);
                    for (Dependency t : trans) {
                        if (this.resolvedDependencies.contains(t)) continue;
                        toResolve.add(t);
                    }
                    found = true;
                    break;
                }
                catch (Exception e) {
                    log.error("Failed to resolve dependency {}", (Object)cur, (Object)base);
                }
            }
            if (found) continue;
            throw new Exception("Failed to resolve dependency '" + cur + "'!");
        }
        for (Dependency d : this.resolvedDependencies) {
            File file = this.getFileLocation(d);
            this.classPathUrls.add(file.toURI().toURL());
        }
        return this.resolvedDependencies;
    }

    protected File getFileLocation(Dependency d) throws Exception {
        File m2repo = new File(this.localRepo);
        File jar = new File(m2repo.getAbsolutePath() + File.separator + d.getPath());
        File pom = new File(m2repo.getAbsolutePath() + File.separator + d.getPomPath());
        if (jar.isFile() && pom.isFile()) {
            return jar;
        }
        return this.fetch(d, m2repo);
    }

    public List<String> extractVersions(Dependency d) {
        ArrayList<String> vs = new ArrayList<String>();
        for (String base : this.baseUrls) {
            if (base.startsWith("/")) {
                base = "file:" + base;
            }
            String metaXml = base + d.getGroupId().replace('.', '/') + "/" + d.getArtifactId() + "/maven-metadata.xml";
            log.debug("Fetching metadata-xml from {}", (Object)metaXml);
            try {
                URL url = new URL(metaXml);
                Document doc = XMLUtils.parseDocument((InputStream)url.openStream());
                NodeList versions = doc.getElementsByTagName("version");
                for (int i = 0; i < versions.getLength(); ++i) {
                    String ver;
                    Element v = (Element)versions.item(i);
                    if (v.getTextContent() == null || (ver = v.getTextContent().trim()).length() <= 0 || vs.contains(ver)) continue;
                    vs.add(ver);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return vs;
    }

    public File fetch(Dependency d, File repoDir) throws Exception {
        LinkedHashMap<String, String> list = new LinkedHashMap<String, String>();
        list.put("http://repo.maven.apache.org/maven2/" + d.getPomPath(), repoDir.getAbsolutePath() + File.separator + d.getPomPath());
        list.put("http://repo.maven.apache.org/maven2/" + d.getPath(), repoDir.getAbsolutePath() + File.separator + d.getPath());
        File jarFile = new File(repoDir.getAbsolutePath() + File.separator + d.getPath());
        for (String urlString : list.keySet()) {
            File file = new File((String)list.get(urlString));
            if (file.exists()) {
                log.debug("File {} already exists.", (Object)file);
                continue;
            }
            file.getParentFile().mkdirs();
            URL url = new URL(urlString);
            InputStream in = url.openStream();
            log.debug("Downloading artifact {} to {}", (Object)d.getArtifactId(), (Object)file.getAbsolutePath());
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[8192];
            int total = 0;
            int read = in.read(buf);
            while (read > 0) {
                total += read;
                out.write(buf, 0, read);
                read = in.read(buf);
            }
            log.debug("{} bytes fetched.", (Object)total);
            out.close();
        }
        log.debug("Returning jar-file {}", (Object)jarFile.getAbsolutePath());
        return jarFile;
    }

    protected Set<Dependency> extractDependenciesFromPom(String repoUrl, Dependency dep) throws Exception {
        URL pomUrl = new URL(repoUrl + dep.getPomPath());
        log.debug("Using pom @ {}", (Object)pomUrl);
        HashSet<Dependency> resolved = new HashSet<Dependency>();
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document pom = db.parse(pomUrl.openStream());
        Element root = pom.getDocumentElement();
        String pomVersion = null;
        NodeList parent = root.getElementsByTagName("parent");
        for (int k = 0; k < parent.getLength(); ++k) {
            Element p = (Element)parent.item(k);
            NodeList nl = p.getChildNodes();
            for (int n = 0; n < nl.getLength(); ++n) {
                Node ch = nl.item(n);
                if (ch.getNodeType() != 1 || !ch.getNodeName().equals("version")) continue;
                pomVersion = ch.getTextContent();
            }
        }
        NodeList list = root.getElementsByTagName("dependency");
        for (int i = 0; i < list.getLength(); ++i) {
            Element el = (Element)list.item(i);
            log.debug("Checking element {}", (Object)el.getNodeName());
            String groupId = null;
            String artifactId = null;
            String version = null;
            String scope = "compile";
            NodeList children = el.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node node = children.item(j);
                if (node.getNodeName().equals("groupId")) {
                    groupId = node.getTextContent();
                }
                if (node.getNodeName().equals("artifactId")) {
                    artifactId = node.getTextContent();
                }
                if (node.getNodeName().equals("version")) {
                    version = node.getTextContent();
                }
                if (!node.getNodeName().equals("scope")) continue;
                scope = node.getTextContent();
            }
            if (pomVersion != null && "${pom.version}".equals(version)) {
                version = pomVersion;
            }
            log.debug("artifact '{}', group '{}'", artifactId, groupId);
            log.debug("    scope = '{}', version = '{}'", (Object)scope, (Object)version);
            if (groupId == null || artifactId == null) continue;
            if (version != null && version.startsWith("[")) {
                version = version.substring(1);
            }
            if (version != null && version.endsWith(",)")) {
                version = version.replace(",)", "");
            }
            if (this.isScopeIncluded(scope)) {
                log.debug("Adding dependency {} with scope {}", (Object)artifactId, (Object)scope);
                Dependency d = new Dependency(groupId, artifactId, version);
                List<String> versions = this.extractVersions(d);
                d.addVersions(versions);
                log.debug("{} versions are: {}", (Object)artifactId, versions);
                String sel = this.selectVersion(versions, version);
                log.debug("Selected version is: {}", (Object)sel);
                d.version = sel;
                resolved.add(d);
                continue;
            }
            log.debug("Dependencies with scope '{}' will be ignored.", (Object)scope);
        }
        return resolved;
    }

    public String selectVersion(List<String> versions, String ver) {
        if (ver != null && versions.contains(ver)) {
            log.debug("selecting specific version {}", (Object)ver);
            return ver;
        }
        String sel = versions.get(versions.size() - 1);
        log.debug("selecting last version in list {} => {}", versions, (Object)sel);
        return sel;
    }

    public boolean isScopeIncluded(String scope) {
        if (scope == null || this.scopes.contains(scope.toLowerCase())) {
            log.debug("scope '{}' will be included...", (Object)scope);
            return true;
        }
        log.debug("scope '{}' will be excluded", (Object)scope);
        return false;
    }
}

