/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import java.util.LinkedHashMap;
import java.util.Map;

public class Priority {
    static final Map<String, Integer> PRIORITY_NAMES = new LinkedHashMap<String, Integer>();
    private Integer value = 5;

    public Priority() {
        this.init(5);
    }

    public Priority(Integer value) {
        this.init(value);
    }

    public Priority(String val) {
        this.init(Priority.parse(val));
    }

    private static Integer parse(String prioValue) {
        Integer prio = 5;
        try {
            if (prioValue == null) {
                prioValue = "normal";
            }
            if (PRIORITY_NAMES.containsKey(prioValue)) {
                prioValue = PRIORITY_NAMES.get(prioValue).toString();
            }
            prio = new Integer(prioValue);
        }
        catch (Exception e) {
            prio = 5;
        }
        return prio;
    }

    private void init(Integer prio) {
        if (prio == null) {
            this.value = 5;
            return;
        }
        if (prio > 10) {
            this.value = 10;
            return;
        }
        if (prio < 1) {
            this.value = 1;
        }
    }

    public Integer value() {
        return this.value;
    }

    static {
        PRIORITY_NAMES.put("lowest", 1);
        PRIORITY_NAMES.put("low", 2);
        PRIORITY_NAMES.put("normal", 5);
        PRIORITY_NAMES.put("high", 7);
        PRIORITY_NAMES.put("highest", 10);
    }
}

