/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.app.ComputeGraph;
import stream.app.Reference;
import stream.io.DefaultBlockingQueue;
import stream.io.Queue;
import stream.io.Sink;
import stream.io.Source;
import stream.runtime.setup.ParameterInjection;
import stream.service.NamingService;
import stream.service.Service;

public class DependencyInjection {
    static Logger log = LoggerFactory.getLogger(DependencyInjection.class);
    final List<Reference> refs = new ArrayList<Reference>();

    public void add(Reference ref) {
        this.refs.add(ref);
    }

    public void addAll(Collection<Reference> refs) {
        this.refs.addAll(refs);
    }

    public void injectDependencies(ComputeGraph graph, NamingService namingService) throws Exception {
        log.debug("Found {} references to be resolved...", this.refs);
        Iterator<Reference> it = this.refs.iterator();
        while (it.hasNext()) {
            Reference ref = it.next();
            log.debug("next unresolved reference is {}", (Object)ref);
            boolean success = this.inject(ref, graph, namingService);
            if (success) {
                log.debug("Successfully injected dependency {}", (Object)ref);
                it.remove();
                continue;
            }
            log.error("Failed to resolve dependency {}", (Object)ref);
        }
        if (!this.refs.isEmpty()) {
            throw new Exception(this.refs.size() + " unresolved dependencies!");
        }
    }

    private boolean inject(Reference ref, ComputeGraph graph, NamingService namingService) throws Exception {
        if (ref instanceof ComputeGraph.SinkRef) {
            return this.inject((ComputeGraph.SinkRef)ref, graph);
        }
        if (ref instanceof ComputeGraph.SourceRef) {
            return this.inject((ComputeGraph.SourceRef)ref, graph);
        }
        if (ref instanceof ComputeGraph.ServiceRef) {
            return this.inject((ComputeGraph.ServiceRef)ref, graph, namingService);
        }
        return false;
    }

    private boolean inject(ComputeGraph.SinkRef ref, ComputeGraph graph) throws Exception {
        log.debug("Injecting sink reference {}", (Object)ref);
        String[] refs = ref.ids();
        Object[] sinks = new Sink[refs.length];
        for (int i = 0; i < sinks.length; ++i) {
            sinks[i] = (Sink)graph.sinks().get(refs[i]);
            if (sinks[i] == null) {
                DefaultBlockingQueue queue = new DefaultBlockingQueue();
                queue.setId(refs[i]);
                graph.addQueue(refs[i], (Queue)queue);
                if (queue instanceof Service) {
                    graph.addService(refs[i], (Service)queue);
                }
                log.debug("Creating implicitly defined queue: {}", (Object)queue);
                sinks[i] = queue;
            }
            graph.add(ref.object(), sinks[i]);
        }
        return this.injectResolvedReferences(ref.object(), ref.property(), sinks);
    }

    private boolean inject(ComputeGraph.SourceRef ref, ComputeGraph graph) throws Exception {
        log.debug("Injecting source reference {}", (Object)ref);
        String[] refs = ref.ids();
        Object[] sources = new Source[refs.length];
        for (int i = 0; i < sources.length; ++i) {
            sources[i] = (Source)graph.sources().get(refs[i]);
            if (sources[i] == null) {
                DefaultBlockingQueue queue = new DefaultBlockingQueue();
                queue.setId(refs[i]);
                graph.addQueue(refs[i], (Queue)queue);
                if (queue instanceof Service) {
                    graph.addService(refs[i], (Service)queue);
                }
                log.info("Created new Queue:{} {}", (Object)queue.getId(), (Object)queue);
                sources[i] = queue;
            }
            graph.add(sources[i], ref.object());
        }
        return this.injectResolvedReferences(ref.object(), ref.property(), sources);
    }

    private boolean inject(ComputeGraph.ServiceRef ref, ComputeGraph graph, NamingService namingService) throws Exception {
        log.debug("Injecting service reference {}", (Object)ref);
        String[] refs = ref.ids();
        Object[] services = new Service[refs.length];
        for (int i = 0; i < services.length; ++i) {
            services[i] = namingService.lookup(refs[i], ref.type());
            if (services[i] != null) continue;
            log.error("Referenced service '{}' not found!", (Object)refs[i]);
            String obj = ref.object() + "";
            if (ref.object() != null) {
                obj = ref.object().getClass().getName();
            }
            throw new Exception("Service '" + refs[i] + "' referenced by " + obj + " can not be found!");
        }
        return this.injectResolvedReferences(ref.object(), ref.property(), services);
    }

    public boolean injectResolvedReferences(Object o, String property, Object[] resolvedRefs) throws Exception {
        String name = "set" + property.toLowerCase();
        for (Method m : o.getClass().getMethods()) {
            if (!m.getName().toLowerCase().equalsIgnoreCase(name) || m.getParameterTypes().length != 1) continue;
            Class<?> type = m.getParameterTypes()[0];
            if (type.isArray()) {
                Object values = Array.newInstance(type.getComponentType(), resolvedRefs.length);
                for (int i = 0; i < Array.getLength(values); ++i) {
                    Array.set(values, i, resolvedRefs[i]);
                }
                log.debug("Injecting   '{}'.{}   <-- " + values, o, (Object)property);
                log.debug("Calling method  '{}'", (Object)m);
                m.invoke(o, values);
            } else {
                log.debug("Injecting   '{}'.{}   <-- " + resolvedRefs[0], o, (Object)property);
                log.debug("Calling method  '{}' with arg '{}'", (Object)m, resolvedRefs[0]);
                m.invoke(o, resolvedRefs[0]);
            }
            return true;
        }
        return false;
    }

    public static Class<? extends Sink> hasSinkSetter(String name, Object o) {
        for (Method m : o.getClass().getMethods()) {
            if (!m.getName().toLowerCase().equals("set" + name) || !ParameterInjection.isQueueSetter(m)) continue;
            return m.getParameterTypes()[0];
        }
        return null;
    }

    public static Class<? extends Service> hasServiceSetter(String name, Object o) {
        try {
            for (Method m : o.getClass().getMethods()) {
                if (!m.getName().equalsIgnoreCase("set" + name) || !DependencyInjection.isServiceSetter(m)) continue;
                return m.getParameterTypes()[0];
            }
            return null;
        }
        catch (Exception e) {
            log.error("Failed to determine service-setter: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static boolean isServiceSetter(Method m) {
        if (!m.getName().startsWith("set")) {
            return false;
        }
        Class<?>[] paramTypes = m.getParameterTypes();
        if (paramTypes.length != 1) {
            return false;
        }
        return DependencyInjection.isServiceImplementation(paramTypes[0]);
    }

    public static boolean isSourceSetter(Method m) {
        if (!m.getName().startsWith("set")) {
            return false;
        }
        Class<?>[] paramTypes = m.getParameterTypes();
        if (paramTypes.length != 1) {
            return false;
        }
        return Source.class.isAssignableFrom(paramTypes[0]);
    }

    public static boolean isSinkSetter(Method m) {
        return DependencyInjection.isSetter(m, Sink.class);
    }

    public static boolean isSinkArraySetter(Method m) {
        return DependencyInjection.isArraySetter(m, Sink.class);
    }

    public static boolean isSetter(Method m, Class<?> type) {
        if (!m.getName().startsWith("set")) {
            return false;
        }
        Class<?>[] paramTypes = m.getParameterTypes();
        if (paramTypes.length != 1) {
            return false;
        }
        if (paramTypes[0].isArray()) {
            return type.isAssignableFrom(paramTypes[0].getComponentType());
        }
        return type.isAssignableFrom(paramTypes[0]);
    }

    public static boolean isArraySetter(Method m, Class<?> type) {
        if (DependencyInjection.isSetter(m, type)) {
            return m.getParameterTypes()[0].isArray();
        }
        return false;
    }

    public static boolean isServiceImplementation(Class<?> clazz) {
        if (clazz == Service.class) {
            return true;
        }
        if (clazz.isArray()) {
            log.debug("checking array component-type for service implementation");
            return DependencyInjection.isServiceImplementation(clazz.getComponentType());
        }
        if (Service.class.isAssignableFrom(clazz)) {
            return true;
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            log.trace("Checking if {} = {}", intf, Service.class);
            if (!intf.equals(Service.class) && intf != Service.class) continue;
            log.trace("Yes, class {} implements the service interface!", clazz);
            return true;
        }
        log.trace("No, class {} does not implement the service interface!", clazz);
        return false;
    }
}

