/*
 * Decompiled with CFR 0.152.
 */
package stream;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Start {
    static Logger log = LoggerFactory.getLogger(Start.class);

    public static void main(String[] args) throws Exception {
        URLClassLoader ucl = (URLClassLoader)Start.class.getClassLoader();
        StringBuffer classPath = new StringBuffer();
        URL[] urls = ucl.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            System.out.println("   " + urls[i]);
            if (!urls[i].toURI().getScheme().equalsIgnoreCase("file")) continue;
            classPath.append(new File(urls[i].toURI().getPath()).getAbsolutePath());
            if (i + 1 >= urls.length) continue;
            classPath.append(File.pathSeparatorChar);
        }
        System.out.println("Classpath: " + classPath.toString());
        System.out.println("JAVA_HOME = " + System.getenv("JAVA_HOME"));
        for (String string : System.getenv().keySet()) {
            System.out.println(string + " = " + System.getenv(string));
        }
        System.out.println("------------------------------------------------------");
        for (Object object : System.getProperties().keySet()) {
            System.out.println(object + " = " + System.getProperty(object + ""));
        }
        String exec = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        File file = new File(exec);
        System.out.println("file " + file + " exists? " + file.exists());
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(file.getAbsolutePath());
        for (Object key : System.getProperties().keySet()) {
            if (!key.toString().startsWith("container") && !key.toString().startsWith("stream")) continue;
            cmd.add("-D" + key.toString() + "=" + System.getProperty(key.toString()));
        }
        cmd.add("stream.run");
        cmd.add(args[0]);
        String[] c = cmd.toArray(new String[cmd.size()]);
        ProcessBuilder pb = new ProcessBuilder(c);
        pb.environment().put("CLASSPATH", classPath.toString());
        log.info("Command: {}", pb.command());
        Process jvm = pb.start();
        if (jvm.hashCode() > 0) {
            log.info("Not monitoring spawned JVM... exiting...");
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(jvm.getInputStream()));
        String line = reader.readLine();
        while (line != null) {
            System.out.println(line);
            line = reader.readLine();
        }
        int code = jvm.waitFor();
        reader.close();
        System.out.println("exit code: " + code);
    }
}

