/*
 * Decompiled with CFR 0.152.
 */
package stream.statistics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class History<T>
implements Serializable {
    private static final long serialVersionUID = 9079427772146519028L;
    public static final long MILLISECOND = 1L;
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final long MONTH = 2592000000L;
    public static final long YEAR = 31449600000L;
    long stepSize;
    long historyLength;
    LinkedHashMap<Long, T> map = new LinkedHashMap();
    long last = 0L;

    public History(long stepSize, long historyLength) {
        this.stepSize = stepSize;
        this.historyLength = historyLength;
    }

    public long getStepSize() {
        return this.stepSize;
    }

    public Long getLength() {
        return this.historyLength;
    }

    public T get(int i) {
        Long key = this.map(i);
        return this.map.get(key);
    }

    public int getPosition(Long timestamp) {
        LinkedList<Long> times = new LinkedList<Long>(this.map.keySet());
        return times.indexOf(timestamp);
    }

    public int getSteps() {
        Long steps = new Long(this.getLength() / this.getStepSize());
        return steps.intValue();
    }

    public Long getTimestamp(int i) {
        long first = this.last() - this.getLength();
        long t = first + (long)i * this.stepSize;
        return this.adjust(t);
    }

    public T get(Long timestamp) {
        return this.map.get(this.adjust(timestamp));
    }

    public void add(Long timestamp, T data) {
        Long time = this.adjust(timestamp);
        this.map.put(time, data);
        this.last = Math.max(this.last, time);
    }

    protected Long adjust(Long timestamp) {
        long rest = timestamp % this.stepSize;
        return timestamp - rest;
    }

    public Long mapTimestamp(Long timestamp) {
        return this.adjust(timestamp);
    }

    public void forget() {
        if (this.map.size() < this.getSteps()) {
            return;
        }
        long limit = this.last - this.historyLength;
        LinkedList<Long> delete = new LinkedList<Long>();
        for (Long key : this.map.keySet()) {
            if (key.compareTo(limit) >= 0) continue;
            delete.add(key);
        }
        for (Long key : delete) {
            this.map.remove(key);
        }
    }

    protected long last() {
        return this.last;
    }

    public Long map(int i) {
        long first = this.last() - this.getLength();
        long t = first + (long)i * this.stepSize;
        return this.adjust(t);
    }

    public List<T> getData() {
        ArrayList<T> list = new ArrayList<T>();
        for (Long key : this.map.keySet()) {
            list.add(this.map.get(key));
        }
        return list;
    }

    public void clear() {
        this.last = 0L;
        this.map.clear();
    }
}

