/*
 * Decompiled with CFR 0.152.
 */
package stream.statistics;

import stream.Data;
import stream.annotations.Description;
import stream.statistics.Sum;

@Description(group="Data Stream.Processing.Statistics", text="Continuously determines the average value of numeric attributes")
public class Average
extends Sum {
    Double count = 0.0;

    @Override
    public void updateStatistics(Data item) {
        if (this.keys == null) {
            return;
        }
        this.count = this.count + 1.0;
        for (String key : this.keys) {
            Double val = null;
            try {
                val = new Double(item.get((Object)key) + "");
            }
            catch (Exception e) {
                val = null;
            }
            if (val == null) continue;
            this.statistics.add(key, val);
            if (this.prefix != null) {
                item.put((Object)(this.prefix + key), (Object)((Double)this.statistics.get((Object)key) / this.count));
                continue;
            }
            item.put((Object)key, (Object)((Double)this.statistics.get((Object)key) / this.count));
        }
    }

    @Override
    public void reset() throws Exception {
        super.reset();
        this.count = 0.0;
    }
}

