/*
 * Decompiled with CFR 0.152.
 */
package stream.parser;

import stream.AbstractProcessor;
import stream.Data;
import stream.annotations.Description;
import stream.annotations.Parameter;

@Description(group="Streams.Processing.Transformations.Parsers", text="Parses a double value from a string and replaces the attribute string value with the integer object.")
public class ParseLong
extends AbstractProcessor {
    String[] keys = null;
    Long defaultValue = null;

    public String[] getKeys() {
        return this.keys;
    }

    @Parameter(required=true, description="The keys/attributes to perform parsing on")
    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public Long getDefault() {
        return this.defaultValue;
    }

    @Parameter(required=false, defaultValue="0.0", description="The default value to set if parsing fails")
    public void setDefault(Long defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Data process(Data data) {
        String[] ks = this.keys;
        if (ks == null) {
            ks = data.keySet().toArray(new String[data.keySet().size()]);
        }
        for (String key : this.keys) {
            Long value = this.defaultValue;
            try {
                value = new Long(data.get((Object)key) + "");
                data.put((Object)key, (Object)value);
            }
            catch (Exception e) {
                if (this.defaultValue == null) continue;
                data.put((Object)key, (Object)this.defaultValue);
            }
        }
        return data;
    }
}

