/*
 * Decompiled with CFR 0.152.
 */
package stream.net;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.net.ConnectionHandler;

public class Connection
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(Connection.class);
    protected Socket socket;
    protected LinkedBlockingQueue<Data> buffer;
    protected boolean running = true;
    protected int bufferSize;
    protected boolean disconnectSlowClients = true;
    protected ConnectionHandler connectionHandler;
    protected ObjectOutputStream out;

    public Connection(ConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
    }

    public void init(Socket socket, int bufferSize, boolean gzip, boolean disconnectSlowClients) throws IOException {
        this.disconnectSlowClients = disconnectSlowClients;
        this.buffer = new LinkedBlockingQueue(bufferSize);
        this.socket = socket;
        FilterOutputStream innerOut = new BufferedOutputStream(socket.getOutputStream());
        if (gzip) {
            innerOut = new GZIPOutputStream(innerOut);
        }
        this.out = new ObjectOutputStream(innerOut);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Data item;
                    if ((item = this.buffer.take()) == null) {
                        continue;
                    }
                    this.out.writeObject(item);
                    this.out.flush();
                    this.out.reset();
                }
            }
            catch (SocketException se) {
                this.log.warn(se.toString());
                this.close();
                continue;
            }
            catch (Exception e) {
                this.log.error("Unexpected exception in client thread:", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void close() {
        this.log.info("Closing client socket {}", (Object)this.socket);
        try {
            this.socket.close();
            this.running = false;
        }
        catch (IOException e) {
            this.log.error("Exception thrown while closing client socket " + this.socket, (Throwable)e);
        }
        this.buffer.clear();
        this.connectionHandler.unregister(this);
    }

    public boolean write(Data item) throws InterruptedException {
        return this.buffer.offer(item);
    }

    public boolean isRunning() {
        return this.running;
    }

    public String toString() {
        return super.toString() + " - client on socket " + this.socket;
    }
}

