/*
 * Decompiled with CFR 0.152.
 */
package stream.monitor;

import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.ProcessContext;
import stream.data.Statistics;
import stream.statistics.StatisticsService;

public class DataRate
extends AbstractProcessor
implements StatisticsService {
    final DecimalFormat fmt = new DecimalFormat("0.000");
    static Logger log = LoggerFactory.getLogger(DataRate.class);
    String clock = null;
    Long count = 0L;
    Long start = null;
    Long windowCount = 0L;
    Long last = 0L;
    Double elapsed = 0.0;
    Double rate = new Double(0.0);
    Integer every = null;
    String key = "dataRate";
    String id;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getClock() {
        return this.clock;
    }

    public void setClock(String clock) {
        this.clock = clock;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data process(Data input) {
        Long t;
        if (this.start == null) {
            this.start = System.currentTimeMillis();
        }
        Long l = this.count;
        Number number = this.count = Long.valueOf(this.count + 1L);
        if (this.every != null && this.count % (long)this.every.intValue() == 0L) {
            this.printDataRate(System.currentTimeMillis());
        }
        if ((t = Long.valueOf(System.currentTimeMillis() - this.start)) > 0L && this.count % 10L == 0L) {
            number = this.rate;
            synchronized (number) {
                this.rate = this.count.doubleValue() / (t.doubleValue() / 1000.0);
            }
        }
        return input;
    }

    public void printDataRate() {
        this.printDataRate(System.currentTimeMillis());
    }

    protected void printDataRate(Long now) {
        Long sec = (now - this.start) / 1000L;
        if (sec > 0L) {
            log.info("Data rate '" + this.getId() + "': {} items processed, data-rate is: {}/second", (Object)this.count, (Object)this.fmt.format(this.count.doubleValue() / sec.doubleValue()));
        }
    }

    public void finish() throws Exception {
        super.finish();
        if (this.start != null) {
            Long now = System.currentTimeMillis();
            Long sec = now - this.start;
            log.info("DataRate processor '" + this.id + "' has been running for {} ms, {} items.", (Object)sec, (Object)this.count.doubleValue());
            Double s = sec.doubleValue() / 1000.0;
            if (s > 0.0) {
                log.info("Overall average data-rate for processor '{}' is: {}/second", (Object)this.id, (Object)this.fmt.format(this.count.doubleValue() / s));
            }
        } else {
            log.info("Start time not available.");
        }
    }

    public void reset() throws Exception {
        this.count = 0L;
        this.windowCount = 1L;
        this.last = 0L;
        this.start = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statistics getStatistics() {
        Statistics st = new Statistics();
        Double d = this.rate;
        synchronized (d) {
            st.put((Object)"dataRate", (Object)new Double(this.rate));
        }
        return st;
    }

    public Integer getEvery() {
        return this.every;
    }

    public void setEvery(Integer every) {
        this.every = every;
    }
}

