/*
 * Decompiled with CFR 0.152.
 */
package stream.lookup;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.annotations.Parameter;
import stream.data.DataFactory;
import stream.io.SourceURL;
import stream.io.sql.DatabaseDialect;
import stream.io.sql.HsqlDialect;
import stream.runtime.ApplicationContext;
import stream.runtime.LifeCycle;
import stream.service.LookupService;

public class SQLDatabase
implements LookupService,
LifeCycle {
    static Logger log = LoggerFactory.getLogger(SQLDatabase.class);
    @Parameter(description="The database URL. This is expected to be JDBC compatible URL.")
    SourceURL url;
    @Parameter(description="The user to connect to the database.")
    String username = "";
    @Parameter(description="The password for connecting to the database.")
    String password = "";
    @Parameter(description="The SQL query to call for the lookup. The '?' character is used as placeholder for the ID value.")
    String select;
    String[] columns;
    DatabaseDialect dialect = new HsqlDialect();
    transient Connection connection;
    transient PreparedStatement statement;

    public void reset() throws Exception {
    }

    public void init(ApplicationContext context) throws Exception {
        try {
            log.info("Opening connection to database {}", (Object)this.getUrl());
            SourceURL url = this.getUrl();
            this.connection = DriverManager.getConnection(url.toString(), this.getUsername(), this.getPassword());
            this.statement = this.connection.prepareStatement(this.select);
        }
        catch (Exception e) {
            log.error("Failed to connect to database: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public void finish() throws Exception {
        this.connection.close();
    }

    @Override
    public Data lookup(String key) {
        Data item = null;
        try {
            log.debug("Calling statement for key '{}'", (Object)key);
            this.statement.setString(1, key);
            ResultSet rs = this.statement.executeQuery();
            if (rs.next()) {
                item = DataFactory.create();
                if (this.columns == null) {
                    ResultSetMetaData meta = rs.getMetaData();
                    this.columns = new String[meta.getColumnCount()];
                    for (int i = 0; i < this.columns.length; ++i) {
                        this.columns[i] = meta.getColumnName(i + 1);
                    }
                }
                for (String col : this.columns) {
                    Object object = rs.getObject(col);
                    String k = this.dialect.unmapColumnName(col);
                    item.put((Object)k, (Object)((Serializable)object));
                }
            } else {
                log.debug("No result for lookup of key '{}'", (Object)key);
            }
            rs.close();
        }
        catch (Exception e) {
            log.error("Failed to run select for lookup('{}'): {}", (Object)key, (Object)e.getMessage());
            e.printStackTrace();
        }
        return item;
    }

    public SourceURL getUrl() {
        return this.url;
    }

    public void setUrl(SourceURL url) {
        this.url = url;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

