/*
 * Decompiled with CFR 0.152.
 */
package stream.io.multi;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.io.AbstractStream;
import stream.io.SourceURL;
import stream.io.Stream;
import stream.io.active.ActiveStream;
import stream.io.active.SimpleActiveStream;
import stream.io.multi.MultiStream;

public abstract class AbstractMultiStream
extends AbstractStream
implements MultiStream {
    protected Logger log = LoggerFactory.getLogger(AbstractMultiStream.class);
    protected List<String> additionOrder;
    protected Map<String, Stream> streams;
    protected Boolean activate = false;
    protected ActiveStream activeWrapper;
    ExecutorService pool;

    public AbstractMultiStream(SourceURL url) {
        super(url);
    }

    public AbstractMultiStream(InputStream in) {
        super(in);
    }

    public AbstractMultiStream() {
    }

    public Boolean getActivate() {
        return this.activate;
    }

    public void setActivate(Boolean activate) {
        this.activate = activate;
    }

    public void addStream(String id, Stream stream) {
        if (this.streams == null) {
            this.streams = new HashMap<String, Stream>();
            this.additionOrder = new ArrayList<String>();
        }
        this.streams.put(id, stream);
        this.additionOrder.add(id);
        this.log.debug("added Stream {}", (Object)stream);
    }

    public Map<String, Stream> getStreams() {
        return this.streams;
    }

    public void init() throws Exception {
        for (Stream s : this.streams.values()) {
            s.init();
        }
        this.log.info("initialized all Streams.");
        if (this.activate.booleanValue()) {
            this.pool = Executors.newFixedThreadPool(1);
            this.activeWrapper = new SimpleActiveStream((Stream)this, this.pool);
            this.activeWrapper.activate();
            this.log.info("Activated this multiStream.");
        }
    }

    public void close() throws Exception {
        for (Stream s : this.streams.values()) {
            try {
                s.close();
            }
            catch (Exception e) {
                this.log.error("Failed to close stream {}: {}", (Object)s, (Object)e.getMessage());
            }
        }
    }
}

