/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.annotations.Description;
import stream.annotations.Parameter;
import stream.io.AbstractLineStream;
import stream.io.CsvStream;
import stream.io.SourceURL;
import stream.io.Stream;

@Description(name="Stream Process (exec)", group="Data Stream.Sources")
public class ProcessStream
extends AbstractLineStream {
    static Logger log = LoggerFactory.getLogger(ProcessStream.class);
    protected Process process;
    protected Stream dataStream;
    protected Class<? extends Stream> dataStreamClass = CsvStream.class;
    protected String format;
    protected String command;

    public ProcessStream() {
        super((SourceURL)null);
    }

    public String getCommand() {
        return this.command;
    }

    @Parameter(required=true, description="The command to execute. This command will be spawned and is assumed to output data to standard output.")
    public void setCommand(String command) {
        this.command = command;
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public void init() throws Exception {
        Runtime runtime = Runtime.getRuntime();
        this.process = runtime.exec(this.command);
        this.dataStreamClass = Class.forName(this.format);
        Constructor<? extends Stream> stream = this.dataStreamClass.getConstructor(InputStream.class);
        InputStream input = this.process.getInputStream();
        this.dataStream = stream.newInstance(input);
        this.dataStream.init();
    }

    @Parameter(required=true, values={"stream.io.CsvStream", "stream.io.SvmLight", "stream.io.JSONStream", "stream.io.LineStream"}, defaultValue="stream.io.CsvStream", description="The format of the input (standard input), defaults to CSV")
    public void setFormat(String format) {
        this.format = format;
    }

    public Data readNext() throws Exception {
        if (this.process == null) {
            this.init();
        }
        return this.dataStream.read();
    }

    @Override
    public void close() {
        if (this.process != null) {
            this.process.destroy();
        }
    }
}

