/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.data.DataFactory;
import stream.io.AbstractWriter;

public class JSONWriter
extends AbstractWriter {
    static Logger log = LoggerFactory.getLogger(JSONWriter.class);
    PrintStream p;

    public JSONWriter() {
    }

    public JSONWriter(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    public JSONWriter(OutputStream out) throws IOException {
        this.p = new PrintStream(out);
    }

    @Override
    public void write(Data datum) {
        Data item = DataFactory.create();
        for (String key : this.selectedKeys(datum)) {
            if (!datum.containsKey((Object)key)) continue;
            item.put((Object)key, datum.get((Object)key));
        }
        if (this.p != null) {
            this.p.println(JSONObject.toJSONString((Map)item));
        } else {
            log.error("JSONWriter has not been set right: PrintStream is null.");
        }
    }
}

