/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.annotations.Parameter;
import stream.data.DataFactory;
import stream.util.ByteSize;

public class JSONBlockWriter
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(JSONBlockWriter.class);
    ByteSize blockSize = new ByteSize(Integer.valueOf(0x4000000));
    File directory;
    File currentBlock = null;
    FileOutputStream out;
    long bytesWritten = 0L;
    int blocksCreated = 0;
    String pattern = "yyyy/MM/dd/HH00";
    SimpleDateFormat fmt = new SimpleDateFormat(this.pattern);
    String timeKey = "timestamp";
    String blockFormat = "block-${blockId}.json";

    public Data process(Data input) {
        Long time = System.currentTimeMillis();
        try {
            time = new Long(((Serializable)input.get((Object)this.timeKey)).toString());
        }
        catch (Exception e) {
            time = System.currentTimeMillis();
        }
        try {
            if (this.directory != null) {
                Data dat = DataFactory.create((Map)input);
                for (String key : dat.keySet()) {
                    Serializable val = (Serializable)dat.get((Object)key);
                    if (!val.getClass().isArray() || val.getClass().getComponentType() != Byte.TYPE) continue;
                    try {
                        String enc = DatatypeConverter.printBase64Binary((byte[])((byte[])val));
                        dat.put((Object)key, (Object)enc);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                byte[] json = (JSONObject.toJSONString((Map)input) + "\n").getBytes();
                File parent = new File(this.directory.getAbsolutePath() + File.separator + this.fmt.format(new Date(time)) + File.separator);
                if (this.currentBlock != null && !this.currentBlock.getCanonicalPath().startsWith(parent.getCanonicalPath())) {
                    log.info("Change of target path detected!");
                    this.out.flush();
                    this.out.close();
                    this.out = null;
                    this.blocksCreated = 0;
                }
                if (this.out != null && this.bytesWritten + (long)json.length >= (long)this.blockSize.getBytes()) {
                    this.out.flush();
                    this.out.close();
                    this.out = null;
                    log.info("Block {} full!", (Object)this.currentBlock);
                }
                if (this.out == null) {
                    this.currentBlock = new File(parent.getAbsolutePath() + File.separator + this.blockFormat.replace("${blockId}", this.blocksCreated + ""));
                    log.info("Opening new block at {}", (Object)this.currentBlock);
                    if (parent != null && !parent.isDirectory()) {
                        parent.mkdirs();
                        if (!parent.isDirectory()) {
                            log.error("Failed to create directory {}", (Object)parent);
                        }
                    }
                    this.out = new FileOutputStream(this.currentBlock);
                    this.bytesWritten = 0L;
                    ++this.blocksCreated;
                }
                this.out.write(json);
                this.bytesWritten += (long)json.length;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return input;
    }

    public ByteSize getBlockSize() {
        return this.blockSize;
    }

    @Parameter(description="The size of the blocks that are to be written. Default is 64M.")
    public void setBlockSize(ByteSize blockSize) {
        this.blockSize = blockSize;
    }

    public File getDirectory() {
        return this.directory;
    }

    @Parameter(description="The base directory in which the file are to be stored.", required=true)
    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Parameter(description="A data-time pattern that is used to create subdirectories where to store blocks (within the base directory). The default pattern is `yyyy/MM/dd/HH00`.")
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getTimeKey() {
        return this.timeKey;
    }

    @Parameter(description="The key that is used for determining the current time. If not specified, the default key `timestamp` is used. If a data item does not contain a timestamp, the current system time is used.")
    public void setTimeKey(String timeKey) {
        this.timeKey = timeKey;
    }
}

