/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.ProcessContext;

public class DweetWriter
extends AbstractProcessor {
    static Logger logger = LoggerFactory.getLogger(DweetWriter.class);
    protected String machine;
    protected String id;
    protected String thing;
    protected String baseUrl;
    protected String[] keys;
    protected String prefix;
    protected String[] postKeys;

    public String getMachine() {
        return this.machine;
    }

    public void setMachine(String machine) {
        this.machine = machine;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getThing() {
        return this.thing;
    }

    public void setThing(String thing) {
        this.thing = thing;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.baseUrl = "https://dweet.io:443/dweet/for/";
        String prefix = this.machine + "_" + this.id;
        this.postKeys = new String[this.keys.length];
        for (int i = 0; i < this.keys.length; ++i) {
            this.postKeys[i] = prefix + "_" + this.keys[i] + "=";
            this.postKeys[i] = this.postKeys[i].replace(":", "_");
            this.postKeys[i] = this.postKeys[i].replace("@", "_");
            this.postKeys[i] = this.postKeys[i].replace("-", "_");
        }
    }

    public Data process(Data data) {
        StringBuilder b = new StringBuilder();
        b.append(this.baseUrl);
        b.append(this.thing);
        int count = 0;
        boolean first = true;
        for (int i = 0; i < this.keys.length; ++i) {
            Serializable dk = (Serializable)data.get((Object)this.keys[i]);
            if (dk == null) continue;
            if (first) {
                b.append("?");
                first = false;
            } else {
                b.append("&");
            }
            b.append(this.postKeys[i]);
            ++count;
            b.append(dk.toString());
        }
        if (count > 0) {
            String surl = b.toString();
            System.out.println(surl);
            URL url = null;
            try {
                url = new URL(surl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                logger.info("dweet.io says {}", (Object)connection.getResponseCode());
                connection.disconnect();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            logger.info("nothing to dweet!");
        }
        return data;
    }
}

