/*
 * Decompiled with CFR 0.152.
 */
package stream.generator;

public class SFMT19937 {
    public static final int MEXP = 19937;
    static final int N = 156;
    public static final int N32 = 624;
    static final int POS1 = 122;
    static final int SL1 = 18;
    static final int SL2 = 1;
    static final int SR1 = 11;
    static final int SR2 = 1;
    static final int MSK1 = -536870929;
    static final int MSK2 = -570504321;
    static final int MSK3 = -1074069505;
    static final int MSK4 = -1073741834;
    static final int PARITY1 = 1;
    static final int PARITY2 = 0;
    static final int PARITY3 = 0;
    static final int PARITY4 = 331998852;
    static final int[] parity = new int[]{1, 0, 0, 331998852};
    static long uniquifier = 314159265358979L;
    final int[] sfmt = new int[624];
    int idx = 624;

    public SFMT19937() {
        this(System.nanoTime() + uniquifier++);
    }

    public SFMT19937(long seed) {
        this.setSeed(seed);
    }

    void doRecursion(int[] r, int rI, int[] a, int aI, int[] b, int bI, int[] c, int cI, int[] d, int dI) {
        int lShift = 8;
        int a0 = a[aI];
        int a1 = a[aI + 1];
        int a2 = a[aI + 2];
        int a3 = a[aI + 3];
        long hi = (long)a3 << 32 | (long)a2 & 0xFFFFFFFFL;
        long lo = (long)a1 << 32 | (long)a0 & 0xFFFFFFFFL;
        long outLo = lo << 8;
        long outHi = hi << 8 | lo >>> 56;
        int x0 = (int)outLo;
        int x1 = (int)(outLo >>> 32);
        int x2 = (int)outHi;
        int x3 = (int)(outHi >>> 32);
        int rShift = 8;
        hi = (long)c[cI + 3] << 32 | (long)c[cI + 2] & 0xFFFFFFFFL;
        lo = (long)c[cI + 1] << 32 | (long)c[cI] & 0xFFFFFFFFL;
        outHi = hi >>> 8;
        outLo = lo >>> 8 | hi << 56;
        int y0 = (int)outLo;
        int y1 = (int)(outLo >>> 32);
        int y2 = (int)outHi;
        int y3 = (int)(outHi >>> 32);
        r[rI] = a0 ^ x0 ^ b[bI] >>> 11 & 0xDFFFFFEF ^ y0 ^ d[dI] << 18;
        r[rI + 1] = a1 ^ x1 ^ b[bI + 1] >>> 11 & 0xDDFECB7F ^ y1 ^ d[dI + 1] << 18;
        r[rI + 2] = a2 ^ x2 ^ b[bI + 2] >>> 11 & 0xBFFAFFFF ^ y2 ^ d[dI + 2] << 18;
        r[rI + 3] = a3 ^ x3 ^ b[bI + 3] >>> 11 & 0xBFFFFFF6 ^ y3 ^ d[dI + 3] << 18;
    }

    void genRandAll() {
        int i;
        int r1 = 616;
        int r2 = 620;
        for (i = 0; i < 136; i += 4) {
            this.doRecursion(this.sfmt, i, this.sfmt, i, this.sfmt, i + 488, this.sfmt, r1, this.sfmt, r2);
            r1 = r2;
            r2 = i;
        }
        while (i < 624) {
            this.doRecursion(this.sfmt, i, this.sfmt, i, this.sfmt, i + -136, this.sfmt, r1, this.sfmt, r2);
            r1 = r2;
            r2 = i;
            i += 4;
        }
    }

    void genRandArray(int[] array, int size) {
        int i;
        if (size > array.length) {
            throw new IllegalArgumentException("Given size " + size + " exceeds array length " + array.length);
        }
        if (size < 624) {
            throw new IllegalArgumentException("Size must be at least 624, but is " + size);
        }
        if (size % 4 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 4: " + size);
        }
        int j = 0;
        int r1I = 616;
        int r2I = 620;
        int[] r1 = this.sfmt;
        int[] r2 = this.sfmt;
        for (i = 0; i < 136; i += 4) {
            this.doRecursion(array, i, this.sfmt, i, this.sfmt, i + 488, r1, r1I, r2, r2I);
            r1 = r2;
            r1I = r2I;
            r2 = array;
            r2I = i;
        }
        while (i < 624) {
            this.doRecursion(array, i, this.sfmt, i, array, i + -136, r1, r1I, r2, r2I);
            assert (r1 == r2);
            r1I = r2I;
            assert (r2 == array);
            r2I = i;
            i += 4;
        }
        while (i < size - 624) {
            this.doRecursion(array, i, array, i - 624, array, i + -136, r1, r1I, r2, r2I);
            assert (r1 == r2);
            r1I = r2I;
            assert (r2 == array);
            r2I = i;
            i += 4;
        }
        while (j < 1248 - size) {
            this.sfmt[j] = array[j + size - 624];
            ++j;
        }
        while (i < size) {
            this.doRecursion(array, i, array, i - 624, array, i + -136, r1, r1I, r2, r2I);
            assert (r1 == r2);
            r1I = r2I;
            assert (r2 == array);
            r2I = i;
            this.sfmt[j] = array[i];
            this.sfmt[j + 1] = array[i + 1];
            this.sfmt[j + 2] = array[i + 2];
            this.sfmt[j + 3] = array[i + 3];
            i += 4;
            j += 4;
        }
    }

    int func1(int x) {
        return (x ^ x >>> 27) * 1664525;
    }

    int func2(int x) {
        return (x ^ x >>> 27) * 1566083941;
    }

    void periodCertification() {
        int i;
        int inner = 0;
        for (i = 0; i < 4; ++i) {
            inner ^= this.sfmt[i] & parity[i];
        }
        for (i = 16; i > 0; i >>= 1) {
            inner ^= inner >> i;
        }
        if (inner & true) {
            return;
        }
        for (i = 0; i < 4; ++i) {
            int work = 1;
            for (int j = 0; j < 32; ++j) {
                if ((work & parity[i]) != 0) {
                    int n = i;
                    this.sfmt[n] = this.sfmt[n] ^ work;
                    return;
                }
                work <<= 1;
            }
        }
    }

    public int minArraySize() {
        return 624;
    }

    public int next() {
        if (this.idx >= 624) {
            this.genRandAll();
            this.idx = 0;
        }
        return this.sfmt[this.idx++];
    }

    public void fillArray(int[] array) {
        this.genRandArray(array, array.length);
    }

    public void fillArray(int[] array, int elems) {
        this.genRandArray(array, elems);
        this.idx = 624;
    }

    public void setIntSeed(int seed) {
        this.sfmt[0] = seed;
        for (int i = 1; i < 624; ++i) {
            int prev = this.sfmt[i - 1];
            this.sfmt[i] = 1812433253 * (prev ^ prev >>> 30) + i;
        }
        this.periodCertification();
        this.idx = 624;
    }

    public void setSeed(long seed) {
        this.initByArray((int)seed, (int)(seed >>> 32));
    }

    public void initByArray(int ... key) {
        int j;
        int lag = 11;
        int mid = (624 - lag) / 2;
        for (int i = this.sfmt.length - 1; i >= 0; --i) {
            this.sfmt[i] = -1953789045;
        }
        int count = key.length >= 624 ? key.length : 623;
        int r = this.func1(-1953789045);
        int n = mid;
        this.sfmt[n] = this.sfmt[n] + r;
        int n2 = mid + lag;
        this.sfmt[n2] = this.sfmt[n2] + (r += key.length);
        this.sfmt[0] = r;
        int i = 1;
        for (j = 0; j < count && j < key.length; ++j) {
            r = this.func1(this.sfmt[i] ^ this.sfmt[(i + mid) % 624] ^ this.sfmt[(i + 624 - 1) % 624]);
            int n3 = (i + mid) % 624;
            this.sfmt[n3] = this.sfmt[n3] + r;
            int n4 = (i + mid + lag) % 624;
            this.sfmt[n4] = this.sfmt[n4] + (r += key[j] + i);
            this.sfmt[i] = r;
            i = (i + 1) % 624;
        }
        while (j < count) {
            r = this.func1(this.sfmt[i] ^ this.sfmt[(i + mid) % 624] ^ this.sfmt[(i + 624 - 1) % 624]);
            int n5 = (i + mid) % 624;
            this.sfmt[n5] = this.sfmt[n5] + r;
            int n6 = (i + mid + lag) % 624;
            this.sfmt[n6] = this.sfmt[n6] + (r += i);
            this.sfmt[i] = r;
            i = (i + 1) % 624;
            ++j;
        }
        for (j = 0; j < 624; ++j) {
            r = this.func2(this.sfmt[i] + this.sfmt[(i + mid) % 624] + this.sfmt[(i + 624 - 1) % 624]);
            int n7 = (i + mid) % 624;
            this.sfmt[n7] = this.sfmt[n7] ^ r;
            int n8 = (i + mid + lag) % 624;
            this.sfmt[n8] = this.sfmt[n8] ^ (r -= i);
            this.sfmt[i] = r;
            i = (i + 1) % 624;
        }
        this.periodCertification();
        this.idx = 624;
    }
}

