/*
 * Decompiled with CFR 0.152.
 */
package stream.generator;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProportionalOracle {
    static Logger log = LoggerFactory.getLogger(ProportionalOracle.class);
    Random rnd;
    TreeMap<Double, String> map = new TreeMap();
    Map<String, Double> weights = new LinkedHashMap<String, Double>();

    public ProportionalOracle() {
        this(System.currentTimeMillis());
    }

    public ProportionalOracle(Long seed) {
        this.setSeed(seed);
    }

    public void setSeed(Long seed) {
        this.rnd = new Random(seed);
    }

    public void setWeights(Map<String, Double> weights) {
        Double total = 0.0;
        for (Double d : weights.values()) {
            total = total + d;
        }
        Double offset = 0.0;
        for (String key : weights.keySet()) {
            Double w = weights.get(key) / total;
            this.map.put(offset + w, key);
            offset = offset + w;
            this.weights.put(key, w);
        }
    }

    public Set<String> getLabels() {
        return this.weights.keySet();
    }

    public Double getWeight(String key) {
        return this.weights.get(key);
    }

    public String getNext() {
        Double d = this.rnd.nextDouble();
        Double last = 0.0;
        for (Double k : this.map.keySet()) {
            if (last < d && d <= k) {
                String found = this.map.get(k);
                log.debug("Returning value: {}", (Object)found);
                return found;
            }
            last = k;
        }
        String value = this.map.lastEntry().getValue();
        log.debug("Random index was {}, returning default: {}", (Object)d, (Object)value);
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Double last = 0.0;
        for (Double d : this.map.keySet()) {
            s.append("   [" + last + " : " + d + " ]  => " + this.map.get(d) + "\n");
            last = d;
        }
        return s.toString();
    }

    public static void main(String[] args) {
        ProportionalOracle o = new ProportionalOracle();
        HashMap<String, Double> weights = new HashMap<String, Double>();
        weights.put("class0", 25.0);
        weights.put("class1", 70.0);
        weights.put("class2", 5.0);
        o.setWeights(weights);
        LinkedHashMap<String, Double> counts = new LinkedHashMap<String, Double>();
        Double total = 0.0;
        for (int i = 0; i < 100000; ++i) {
            String next = o.getNext();
            Double count = (Double)counts.get(next);
            count = count == null ? Double.valueOf(1.0) : Double.valueOf(count + 1.0);
            counts.put(next, count);
            log.debug("next: {}", (Object)o.getNext());
            total = total + 1.0;
        }
        for (String key : counts.keySet()) {
            log.info("   count( {} ) = {}", (Object)key, counts.get(key));
            log.info("      weight: {}", (Object)((Double)counts.get(key) / total));
        }
    }
}

