/*
 * Decompiled with CFR 0.152.
 */
package stream.generator;

import stream.Data;
import stream.data.DataFactory;
import stream.generator.ColtGaussian;
import stream.io.AbstractStream;
import stream.io.SourceURL;

public class NoisySinusWave
extends AbstractStream {
    protected Double index = 0.0;
    protected Double amplitude = 1.0;
    protected Double frequency = 1.0;
    protected String key = "sin(t)";
    protected ColtGaussian noise;
    protected Long seed = System.currentTimeMillis();
    protected Double mean = 0.0;
    protected Double variance = 1.0;

    public NoisySinusWave() {
        super((SourceURL)null);
    }

    public void init() throws Exception {
        super.init();
        this.noise = new ColtGaussian(this.mean, this.variance, this.seed);
    }

    public Data readNext() throws Exception {
        Data instance = DataFactory.create();
        Double value = this.amplitude * Math.sin(this.frequency * this.index) + this.noise.next();
        instance.put((Object)"t", (Object)this.index);
        instance.put((Object)this.key, (Object)value);
        this.index = this.index + 0.01;
        return instance;
    }

    public Double getAmplitude() {
        return this.amplitude;
    }

    public void setAmplitude(Double amplitude) {
        this.amplitude = amplitude;
    }

    public Double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Double frequency) {
        this.frequency = frequency;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public Double getMean() {
        return this.mean;
    }

    public void setMean(Double mean) {
        this.mean = mean;
    }

    public Double getVariance() {
        return this.variance;
    }

    public void setVariance(Double variance) {
        this.variance = variance;
    }
}

