/*
 * Decompiled with CFR 0.152.
 */
package stream.data.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import stream.AbstractProcessor;
import stream.Data;
import stream.data.TreeNode;
import stream.data.tree.TreeFeature;

public class TreeFeatures
extends AbstractProcessor {
    List<TreeFeature> features = new ArrayList<TreeFeature>();

    public Data process(Data data) {
        ArrayList<String> treeKeys = new ArrayList<String>();
        for (String key : data.keySet()) {
            if (!(data.get((Object)key) instanceof TreeNode)) continue;
            treeKeys.add(key);
        }
        if (treeKeys.isEmpty()) {
            return data;
        }
        for (String treeKey : treeKeys) {
            this.processTree(treeKey, data);
        }
        return data;
    }

    public void add(TreeFeature feature) {
        this.features.add(feature);
    }

    public void processTree(String treeKey, Data data) {
        for (TreeFeature feat : this.features) {
            TreeNode tree = (TreeNode)data.get((Object)treeKey);
            String featureName = feat.createFeatureKey(treeKey);
            Serializable featureValue = feat.compute(tree);
            data.put((Object)featureName, (Object)featureValue);
        }
    }
}

