/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.io.Serializable;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.Keys;
import stream.Processor;
import stream.annotations.Parameter;
import stream.util.parser.TypeParser;

public class RemoveTypes
implements Processor {
    static Logger log = LoggerFactory.getLogger(RemoveTypes.class);
    Class<?>[] classes = new Class[0];
    String[] keys;
    String[] types = new String[0];

    public Data process(Data input) {
        Iterator it = input.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (this.keys != null && !Keys.isSelected((String)key, (String[])this.keys)) {
                log.debug("Skipping non-selected key {}", (Object)key);
                continue;
            }
            Serializable value = (Serializable)input.get((Object)key);
            if (this.toRemove(value.getClass())) {
                log.debug("Removing key '{}' as type '{}' is matching the set of types to remove!", (Object)key, value.getClass());
                it.remove();
                continue;
            }
            log.debug("Type {} not set to be removed.", value.getClass());
        }
        return input;
    }

    protected boolean toRemove(Class<?> type) {
        for (Class<?> t : this.classes) {
            if (t.equals(type)) {
                return true;
            }
            if (!t.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public String[] getTypes() {
        return this.types;
    }

    @Parameter(description="The list of types that are to be removed. Append `[]` to a type to refer to an array of that type.", required=true)
    public void setTypes(String[] types) {
        this.types = types;
        this.classes = TypeParser.parse((String[])types);
    }
}

