/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.Processor;
import stream.annotations.Description;
import stream.annotations.Parameter;

@Description(text="", group="Data Stream.Processing.Transformations.Attributes")
public class MapKeys
implements Processor {
    static Logger log = LoggerFactory.getLogger(MapKeys.class);
    String oldKey;
    String newKey;
    String map;
    Map<String, String> mapping = new LinkedHashMap<String, String>();

    public MapKeys(String oldKey, String newKey) {
        this.oldKey = oldKey;
        this.newKey = newKey;
    }

    public MapKeys() {
        this.oldKey = "";
        this.newKey = "";
    }

    public String getFrom() {
        return this.oldKey;
    }

    public void setFrom(String oldKey) {
        this.oldKey = oldKey;
    }

    public String getTo() {
        return this.newKey;
    }

    public void setTo(String newKey) {
        this.newKey = newKey;
    }

    public String getMap() {
        return this.map;
    }

    @Parameter(name="map", required=false)
    public void setMap(String map) {
        try {
            if (map == null || map.trim().isEmpty()) {
                log.debug("No valid value '{}' for 'map' parameter.", (Object)map);
                return;
            }
            InputStream input = null;
            if (map.startsWith("classpath:")) {
                URL url = MapKeys.class.getResource(map.substring("classpath:".length()));
                log.debug("Reading mapping from {}", (Object)url);
                input = url.openStream();
            } else {
                File file = map.startsWith("file:") ? new File(map.substring("file:".length())) : new File(map);
                log.debug("Reading mappings from file {}", (Object)file);
                input = new FileInputStream(file);
            }
            Properties p = new Properties();
            p.load(input);
            for (Object key : p.keySet()) {
                log.debug("  adding mapping '{}' => '{}'", key, (Object)p.getProperty(key.toString()));
                this.mapping.put(key.toString(), p.getProperty(key.toString()));
            }
            this.map = map;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Data process(Data input) {
        if (this.oldKey != null && this.newKey != null && input.containsKey((Object)this.oldKey)) {
            if (input.containsKey((Object)this.newKey)) {
                log.warn("Overwriting existing key '{}'!", (Object)this.newKey);
            }
            Serializable o = (Serializable)input.remove((Object)this.oldKey);
            input.put((Object)this.newKey, (Object)o);
        }
        for (String key : this.mapping.keySet()) {
            if (!input.containsKey((Object)key)) continue;
            Serializable value = (Serializable)input.remove((Object)key);
            input.put((Object)this.mapping.get(key), (Object)value);
        }
        return input;
    }

    public Map<String, String> getMapping() {
        return this.mapping;
    }

    @Parameter(required=true, description="A list of key mappings.")
    public void setMapping(Map<String, String> mapping) {
        this.mapping = mapping;
    }
}

