/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Context;
import stream.Data;
import stream.annotations.Parameter;
import stream.expressions.ExpressionResolver;
import stream.service.LookupService;

public class Lookup
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(Lookup.class);
    protected LookupService lookup;
    protected String key;

    public LookupService getLookup() {
        return this.lookup;
    }

    public void setLookup(LookupService lookup) {
        this.lookup = lookup;
    }

    public String getKey() {
        return this.key;
    }

    @Parameter(defaultValue="@id")
    public void setKey(String key) {
        this.key = key;
    }

    public Data process(Data item) {
        if (this.lookup == null) {
            log.error("No LookupService injected!");
            return item;
        }
        Serializable value = null;
        value = this.key.indexOf("%{") >= 0 ? (Serializable)ExpressionResolver.resolve((String)this.key, (Context)this.context, (Data)item) : (Serializable)item.get((Object)this.key);
        if (value == null) {
            log.debug("No value for lookup key '{}' in item {}", (Object)this.key, (Object)item);
            return item;
        }
        Data lookupData = this.lookup.lookup(value.toString());
        if (lookupData != null) {
            item.putAll((Map)lookupData);
        }
        return item;
    }
}

