/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.ProcessContext;

public class FormatTimestamp
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(FormatTimestamp.class);
    String from = "@timestamp";
    String key = "date-time";
    String format = "yyyy-MM-dd HH:mm:ss";
    SimpleDateFormat dateFormat;

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.dateFormat = new SimpleDateFormat(this.format);
    }

    public Data process(Data input) {
        block2: {
            try {
                Long val = new Double(input.get((Object)this.from) + "").longValue();
                String fmt = this.dateFormat.format(new Date(val));
                input.put((Object)this.key, (Object)fmt);
            }
            catch (Exception e) {
                log.error("Failed to format timestamp: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block2;
                e.printStackTrace();
            }
        }
        return input;
    }
}

