/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.rules.operators;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Stack;
import org.jwall.web.audit.SyntaxException;
import org.jwall.web.audit.filter.Operator;
import org.jwall.web.audit.rules.Condition;
import org.jwall.web.audit.rules.operators.AbstractCondition;

@XStreamAlias(value="SX")
public class ConditionSX
extends AbstractCondition
implements Condition {
    private static final long serialVersionUID = 6247657062073419253L;
    boolean negate = false;

    public ConditionSX(String var, String exp) throws SyntaxException {
        super(var, exp);
    }

    @Override
    public String getOperator() {
        return Operator.SX.toString();
    }

    @Override
    public String toString() {
        return "@sx";
    }

    @Override
    public boolean matches(String pattern, String input) {
        String filename = input.toLowerCase();
        String wildcardMatcher = pattern.toLowerCase();
        if (filename == null && wildcardMatcher == null) {
            return true;
        }
        if (filename == null || wildcardMatcher == null) {
            return false;
        }
        String[] wcs = ConditionSX.splitOnTokens(wildcardMatcher);
        boolean anyChars = false;
        int textIdx = 0;
        int wcsIdx = 0;
        Stack<int[]> backtrack = new Stack<int[]>();
        do {
            if (backtrack.size() > 0) {
                int[] array = (int[])backtrack.pop();
                wcsIdx = array[0];
                textIdx = array[1];
                anyChars = true;
            }
            while (wcsIdx < wcs.length) {
                if (wcs[wcsIdx].equals("?")) {
                    ++textIdx;
                    anyChars = false;
                } else if (wcs[wcsIdx].equals("*")) {
                    anyChars = true;
                    if (wcsIdx == wcs.length - 1) {
                        textIdx = filename.length();
                    }
                } else {
                    if (anyChars) {
                        if ((textIdx = filename.indexOf(wcs[wcsIdx], textIdx)) == -1) break;
                        int repeat = filename.indexOf(wcs[wcsIdx], textIdx + 1);
                        if (repeat >= 0) {
                            backtrack.push(new int[]{wcsIdx, repeat});
                        }
                    } else if (!filename.regionMatches(textIdx, wcs[wcsIdx], 0, wcs[wcsIdx].length())) break;
                    textIdx += wcs[wcsIdx].length();
                    anyChars = false;
                }
                ++wcsIdx;
            }
            if (wcsIdx != wcs.length || textIdx != filename.length()) continue;
            return true;
        } while (backtrack.size() > 0);
        return false;
    }

    static String[] splitOnTokens(String text) {
        if (text.indexOf(63) == -1 && text.indexOf(42) == -1) {
            return new String[]{text};
        }
        char[] array = text.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == '?' || array[i] == '*') {
                if (buffer.length() != 0) {
                    list.add(buffer.toString());
                    buffer.setLength(0);
                }
                if (array[i] == '?') {
                    list.add("?");
                    continue;
                }
                if (list.size() != 0 && (i <= 0 || ((String)list.get(list.size() - 1)).equals("*"))) continue;
                list.add("*");
                continue;
            }
            buffer.append(array[i]);
        }
        if (buffer.length() != 0) {
            list.add(buffer.toString());
        }
        return list.toArray(new String[list.size()]);
    }
}

