/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.jwall.audit.EventType;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventMessage;
import org.jwall.web.audit.AuditEventType;
import org.jwall.web.audit.IronBeeVariables;
import org.jwall.web.audit.VariableMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;

public class IronBeeAuditEvent
extends LinkedHashMap<String, String>
implements AuditEvent {
    private static final long serialVersionUID = -5660788992216264848L;
    static Logger log = LoggerFactory.getLogger(IronBeeAuditEvent.class);
    public static final String SECTION_BOUNDARY_KEY = "__SECTION_BOUNDARY_KEY__";
    Long timestamp = System.currentTimeMillis();
    AuditEventMessage[] messages;

    public IronBeeAuditEvent() {
    }

    public IronBeeAuditEvent(Data data) {
        this.put("TX_ID", data.get((Object)SECTION_BOUNDARY_KEY) + "");
        for (String key : data.keySet()) {
            Serializable val = (Serializable)data.get((Object)key);
            if (!(val instanceof String)) continue;
            String repl = IronBeeAuditEvent.mapVariable(key);
            log.trace("  Replacing '{}' with '{}'", (Object)key, (Object)repl);
            this.put(repl, val.toString());
        }
        if (data.containsKey((Object)"event_messages")) {
            try {
                AuditEventMessage[] msgs = (AuditEventMessage[])data.get((Object)"event_messages");
                this.messages = msgs;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public EventType getType() {
        return EventType.AUDIT;
    }

    @Override
    public String getEventId() {
        return this.get("TX_ID");
    }

    @Override
    public String getSection(int i) {
        return null;
    }

    @Override
    public Date getDate() {
        return new Date(this.timestamp);
    }

    @Override
    public String getSessionId() {
        return this.get("SESSIONID");
    }

    @Override
    public void setSessionId(String id) {
        this.set("SESSIONID", id);
    }

    @Override
    public boolean isSet(String variable) {
        String var = IronBeeVariables.mapToIronBee(variable);
        if (VariableMapping.isCaseInsensitive(var)) {
            var = var.toUpperCase();
        }
        return this.containsKey(var);
    }

    @Override
    public String get(String variable) {
        String var = IronBeeVariables.mapToIronBee(variable);
        if (VariableMapping.isCaseInsensitive(var)) {
            return (String)super.get(var.toUpperCase());
        }
        return (String)super.get(var);
    }

    @Override
    public List<String> getAll(String variable) {
        String var = IronBeeVariables.mapToIronBee(variable);
        if (VariableMapping.isCaseInsensitive(var)) {
            var = var.toUpperCase();
        }
        ArrayList<String> list = new ArrayList<String>(1);
        if (this.containsKey(var)) {
            list.add(this.get(var));
        }
        return list;
    }

    @Override
    public void set(String variable, String value) {
        if (value == null) {
            this.remove(IronBeeVariables.mapToIronBee(variable));
        } else {
            this.put(IronBeeVariables.mapToIronBee(variable), value);
        }
    }

    @Override
    public void setAll(String variable, List<String> values) {
        if (values.isEmpty()) {
            this.remove(IronBeeVariables.mapToIronBee(variable));
        } else {
            this.put(IronBeeVariables.mapToIronBee(variable), values.get(0));
        }
    }

    @Override
    public List<String> getVariables() {
        return new ArrayList<String>(this.keySet());
    }

    @Override
    public int compareTo(AuditEvent o) {
        if (o == null) {
            return 1;
        }
        if (this == o) {
            return 0;
        }
        int ret = this.timestamp.compareTo(o.getTimestamp());
        if (ret != 0) {
            return ret;
        }
        return this.getEventId().compareTo(o.getEventId());
    }

    @Override
    public String[] getRawData() {
        return new String[0];
    }

    @Override
    public AuditEventType getAuditEventType() {
        return AuditEventType.IronBee;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("\r\n\r\n");
        String boundary = this.get(SECTION_BOUNDARY_KEY);
        s.append("MIME-Version: 1.0\r\nContent-Type: multipart/mixed;");
        if (boundary != null) {
            s.append(" boundary=" + boundary);
        }
        s.append("\r\n\r\n");
        s.append("This is a multi-part message in MIME format.\r\n\r\n");
        for (String key : this.keySet()) {
            if (!key.startsWith("SECTION:")) continue;
            s.append("--");
            s.append(boundary);
            s.append("\r\n");
            s.append(this.get(key));
        }
        s.append("--");
        s.append(boundary);
        s.append("--\r\n");
        return s.toString();
    }

    public static String mapVariable(String str) {
        return str.toUpperCase().replaceAll("-", "_");
    }

    @Override
    public AuditEventMessage[] getEventMessages() {
        return this.messages;
    }
}

