/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.rules;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.text.html.HTMLDocument;
import org.jwall.audit.rules.EventRule;
import org.jwall.audit.rules.RuleContext;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.filter.AuditEventMatch;
import org.jwall.web.audit.rules.Condition;
import org.jwall.web.audit.rules.EventAction;
import org.jwall.web.audit.rules.ValueExtractor;
import org.jwall.web.audit.rules.operators.BeginsWith;
import org.jwall.web.audit.rules.operators.ConditionEQ;
import org.jwall.web.audit.rules.operators.ConditionGE;
import org.jwall.web.audit.rules.operators.ConditionGT;
import org.jwall.web.audit.rules.operators.ConditionLE;
import org.jwall.web.audit.rules.operators.ConditionLT;
import org.jwall.web.audit.rules.operators.ConditionRX;
import org.jwall.web.audit.rules.operators.ConditionSX;
import org.jwall.web.audit.rules.operators.Contains;
import org.jwall.web.audit.rules.operators.EndsWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="EventRule")
public class AuditEventRule
implements EventRule<AuditEvent> {
    public static final String MATCH_ANY_FILTER = "any";
    public static final String MATCH_ALL_FILTERS = "all";
    public static final Class<?>[] CLASSES = new Class[]{AuditEventRule.class, AuditEventMatch.class, ConditionEQ.class, ConditionLT.class, ConditionLE.class, ConditionGT.class, ConditionGE.class, ConditionRX.class, ConditionSX.class, BeginsWith.class, EndsWith.class, Contains.class, HTMLDocument.HTMLReader.TagAction.class};
    static Logger log = LoggerFactory.getLogger(AuditEventRule.class);
    @XStreamAlias(value="enabled")
    @XStreamAsAttribute
    Boolean enabled = true;
    @XStreamAsAttribute
    @XStreamAlias(value="match")
    String match = "all";
    @XStreamAlias(value="Comment")
    String comment = null;
    @XStreamAlias(value="Conditions")
    LinkedList<Condition> conditions = new LinkedList();
    @XStreamAlias(value="Actions")
    LinkedList<EventAction> actions = new LinkedList();

    @Override
    public boolean matches(AuditEvent evt, RuleContext ctx) {
        log.debug("Starting rule {}", (Object)this.identifier());
        log.debug("{} >>  checking rule-match on event '{}'", (Object)this.identifier(), (Object)evt.getEventId());
        if (MATCH_ANY_FILTER.equalsIgnoreCase(this.match)) {
            log.debug("{} >>  rule conditions  =>  OR( {} )", (Object)this.identifier(), this.conditions);
            for (Condition condition : this.conditions) {
                List<String> values = ValueExtractor.extractValues(condition.getVariable(), evt);
                log.debug(String.valueOf(this.identifier()) + " >>  extracted values for '{}' are: {}", (Object)condition.getVariable(), values);
                if (!condition.matches(values)) continue;
                log.debug("{} >>  found matching condition '{}'", (Object)this.identifier(), (Object)condition);
                log.debug("End of rule {}", (Object)this.identifier());
                return true;
            }
            log.debug("{} >>  no conditions matched.", (Object)this.identifier());
            log.debug("End of rule {}", (Object)this.identifier());
            return false;
        }
        log.debug("{} >>  rule conditions  =>  AND( {} )", (Object)this.identifier(), this.conditions);
        for (Condition condition : this.conditions) {
            List<String> values = ValueExtractor.extractValues(condition.getVariable(), evt);
            log.debug(String.valueOf(this.identifier()) + " >>  extracted values for '{}' are: {}", (Object)condition.getVariable(), values);
            if (condition.matches(values)) continue;
            log.debug("{} >>  found non-matching condition '{}'", (Object)this.identifier(), (Object)condition);
            log.debug("End of rule {}", (Object)this.identifier());
            return false;
        }
        log.debug("{} >>  all condition matched, rule triggering.", (Object)this.identifier());
        log.debug("End of rule {}", (Object)this.identifier());
        return true;
    }

    protected String identifier() {
        return super.toString().substring("org.jwall.web.audit.rules.".length());
    }

    public boolean isEnabled() {
        if (this.enabled == null) {
            this.enabled = true;
            return this.enabled;
        }
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getMatch() {
        return this.match;
    }

    public void setMatch(String match) {
        if (MATCH_ALL_FILTERS.equals(match) || MATCH_ANY_FILTER.equals(match)) {
            this.match = match;
        }
    }

    public boolean isMatchAll() {
        return MATCH_ALL_FILTERS.equals(this.match);
    }

    public void setMatchAll(boolean b) {
        this.match = b ? MATCH_ALL_FILTERS : MATCH_ANY_FILTER;
    }

    public List<Condition> getConditions() {
        if (this.conditions == null) {
            this.conditions = new LinkedList();
        }
        log.debug("Returning " + this.conditions.size() + " conditions.");
        return this.conditions;
    }

    public void setConditions(List<Condition> filters) {
        this.conditions = this.conditions == null ? new LinkedList() : new LinkedList<Condition>(filters);
    }

    public boolean add(Condition filter) {
        log.debug("Adding condition ");
        if (this.conditions == null) {
            this.conditions = new LinkedList();
        }
        if (!this.conditions.contains(filter)) {
            this.conditions.add(filter);
            return true;
        }
        return false;
    }

    public boolean remove(Condition filter) {
        if (this.conditions == null) {
            return false;
        }
        Boolean o = this.conditions.remove(filter);
        return o != null;
    }

    public boolean removeCondition(int i) {
        if (this.conditions != null & i >= 0 && i < this.conditions.size()) {
            this.conditions.remove(i);
            return true;
        }
        return false;
    }

    public boolean add(EventAction action) {
        if (this.actions == null) {
            this.actions = new LinkedList();
        }
        if (!this.actions.contains(action)) {
            this.actions.add(action);
            return true;
        }
        return false;
    }

    public boolean remove(EventAction action) {
        if (this.actions == null) {
            return false;
        }
        Boolean o = this.actions.remove(action);
        return o != null;
    }

    public boolean removeAction(int i) {
        if (this.actions != null && i >= 0 && i < this.actions.size()) {
            this.actions.remove(i);
            return true;
        }
        return false;
    }

    public List<EventAction> getActions() {
        return this.actions;
    }

    public void setActions(Set<EventAction> actions) {
        actions = actions == null ? new LinkedHashSet<EventAction>() : new LinkedHashSet<EventAction>(actions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AuditEventRule) {
            AuditEventRule rule = (AuditEventRule)o;
            return this.toString().equals(rule.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Object readResolve() {
        if (this.enabled == null) {
            this.enabled = new Boolean(true);
        }
        return this;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("{ IF\n");
        Iterator it = this.conditions.iterator();
        while (it.hasNext()) {
            Condition filter = (Condition)it.next();
            s.append("\t" + filter + "\n");
            if (!it.hasNext()) continue;
            if (MATCH_ALL_FILTERS.equalsIgnoreCase(this.match)) {
                s.append(" AND ");
                continue;
            }
            s.append("  OR ");
        }
        s.append("\nTHEN\n");
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            EventAction act = (EventAction)i.next();
            s.append("\t" + act + "\n");
            if (!i.hasNext()) continue;
            s.append("\t");
        }
        s.append("}");
        return s.toString();
    }
}

