/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.log.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialFileInputStream
extends InputStream {
    static Logger log = LoggerFactory.getLogger(SequentialFileInputStream.class);
    static final Comparator<File> FILE_ORDER = new Comparator<File>(){

        @Override
        public int compare(File arg0, File arg1) {
            if (arg0 == arg1 || arg0.compareTo(arg1) == 0) {
                return 0;
            }
            Long lastModified = new Long(arg0.lastModified());
            int rc = lastModified.compareTo(arg1.lastModified());
            if (rc == 0) {
                return arg0.getName().compareTo(arg1.getName());
            }
            return rc;
        }
    };
    Integer sleep = 500;
    File file = null;
    File current = null;
    File next = null;
    InputStream reader;
    String pattern = "";
    boolean closed = false;
    long maxWaitingTime = -1L;
    long read = 0L;
    long total = 0L;
    long waitingTime = 0L;
    boolean removeAfterRead = true;
    Set<File> finished = new TreeSet<File>(FILE_ORDER);

    public SequentialFileInputStream(File file) throws IOException {
        this(file, false);
    }

    public SequentialFileInputStream(File file, boolean removeAfterRead) throws IOException {
        this(file, String.valueOf(file.getName()) + "(\\.\\d+)?$", removeAfterRead);
    }

    public SequentialFileInputStream(File file, String pattern, boolean removeAfterRead) throws IOException {
        this.current = this.file = file;
        this.pattern = pattern;
        this.removeAfterRead = removeAfterRead;
        if (this.current.isFile()) {
            this.reader = new FileInputStream(this.current);
        }
    }

    public boolean matchesSequence(File f) {
        if (f.getAbsolutePath().equals(this.file.getAbsolutePath())) {
            return false;
        }
        if (f.isFile() && !f.equals(this.file) && f.getName().matches(this.pattern)) {
            return !this.finished.contains(f);
        }
        return false;
    }

    protected boolean hasNext() {
        File dir = this.file.getParentFile();
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (this.matchesSequence(f) && !f.equals(this.current)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void openNextFile() throws IOException {
        log.debug("Current file {} seems to have ended, checking for next one", (Object)this.current);
        boolean proceeded = false;
        do {
            TreeSet<File> files = new TreeSet<File>(FILE_ORDER);
            File dir = this.file.getParentFile();
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (this.matchesSequence(f) && !this.finished.contains(f)) {
                    files.add(f);
                }
                ++n2;
            }
            TreeSet<File> sequence = files;
            for (File file : sequence) {
                log.debug("   file: {} (modified: {})", (Object)file, (Object)file.lastModified());
            }
            if (!sequence.isEmpty()) {
                if (this.reader != null) {
                    log.debug("Closing old reader on file {}...", (Object)this.current);
                    this.reader.close();
                }
                if (this.removeAfterRead) {
                    log.debug("Removing file {}", (Object)this.current);
                    this.current.delete();
                }
                this.finished.add(this.current);
                log.debug("Read {} bytes from {}", (Object)this.read, (Object)this.current);
                this.current = (File)sequence.first();
                this.read = 0L;
                this.reader = new FileInputStream(this.current);
                log.debug("Now reading from '{}'", (Object)this.current);
                proceeded = true;
                continue;
            }
            try {
                log.debug("After reading {} bytes from {}", (Object)this.read, (Object)this.current);
                log.debug("   a total of {} bytes read so far", (Object)this.total);
                log.debug("No sequential file found for {}, sleeping for {} ms and checking again...", (Object)this.file, (Object)this.sleep);
                Thread.sleep(this.sleep.intValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!proceeded);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read() throws IOException {
        if (!this.closed) ** GOTO lbl4
        return -1;
lbl-1000:
        // 1 sources

        {
            this.openNextFile();
lbl4:
            // 2 sources

            ** while (this.reader == null)
        }
lbl5:
        // 1 sources

        data = this.reader.read();
        while (data == -1) {
            if (this.hasNext()) {
                this.openNextFile();
            } else {
                try {
                    SequentialFileInputStream.log.debug("Waiting for new data to arrive at file {}", (Object)this.current);
                    Thread.sleep(this.sleep.intValue());
                    this.waitingTime += (long)this.sleep.intValue();
                }
                catch (Exception var2_2) {
                    // empty catch block
                }
                if (this.maxWaitingTime > 0L && this.waitingTime > this.maxWaitingTime) {
                    this.closed = true;
                    SequentialFileInputStream.log.debug("Total sleeping time exhausted!");
                    return -1;
                }
            }
            data = this.reader.read();
        }
        ++this.read;
        ++this.total;
        return data;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        if (this.reader == null) {
            return super.available();
        }
        return this.reader.available();
    }

    public static void main(String[] args) throws Exception {
        File input = new File("/tmp/test.log");
        SequentialFileInputStream f = new SequentialFileInputStream(input, false);
        PrintStream out = new PrintStream(new FileOutputStream(new File(String.valueOf(input.getAbsolutePath()) + "-complete")));
        byte[] buf = new byte[1024];
        int read = 0;
        int written = 0;
        do {
            if (f.available() > 0) {
                buf = new byte[Math.min(1024, f.available())];
            }
            if ((read = f.read(buf)) >= 0) {
                written += read;
                out.write(buf, 0, read);
                out.flush();
            }
            log.debug("{} bytes written", (Object)written);
        } while (read > 0);
    }
}

