/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.audit.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jwall.audit.Event;
import org.jwall.audit.EventType;
import org.jwall.audit.EventView;
import org.jwall.audit.script.EventList;
import org.jwall.audit.script.ScriptEvent;
import org.jwall.web.audit.filter.FilterCompiler;
import org.jwall.web.audit.filter.FilterException;
import org.jwall.web.audit.filter.FilterExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEventView<E extends Event> {
    static Logger log = LoggerFactory.getLogger(ScriptEventView.class);
    String user;
    EventView<E> view;

    public ScriptEventView(String user, EventView<E> parentView) {
        log.debug("Creationg ScriptEventView for user {}", (Object)user);
        this.user = user;
        this.view = parentView;
    }

    public List<ScriptEvent> list() {
        return this.list("");
    }

    public List<ScriptEvent> list(String filter) {
        try {
            return new EventList<E>(this.view, FilterCompiler.parse(filter));
        }
        catch (FilterException e) {
            e.printStackTrace();
            return new ArrayList<ScriptEvent>();
        }
    }

    public List<ScriptEvent> list(String filter, int offset, int max) throws Exception {
        try {
            List<E> list = this.view.list(FilterCompiler.parse(filter), offset, max);
            ArrayList<ScriptEvent> results = new ArrayList<ScriptEvent>();
            for (Event e : list) {
                results.add(new ScriptEvent(e));
            }
            return results;
        }
        catch (Exception e) {
            log.error("Failed to execute list() operation: {}", (Object)e.getMessage());
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return new ArrayList<ScriptEvent>();
        }
    }

    public void tag(ScriptEvent event, String name) throws Exception {
        if (this.view == null) {
            log.error("No AuditEventView associated with this ScriptEventView!");
            return;
        }
        if (event != null && event.getType() == EventType.AUDIT) {
            String id = event.get("TX_ID");
            log.info("tag( {}, '{}' )", (Object)id, (Object)name);
            FilterExpression f = FilterCompiler.parse("TX_ID @eq '" + id + "'");
            this.view.tag(f, name);
        }
    }

    public void untag(ScriptEvent event, String name) throws Exception {
        if (this.view == null) {
            log.error("No AuditEventView associated with this ScriptEventView!");
            return;
        }
        if (event != null && event.getType() == EventType.AUDIT) {
            log.info("tag( {}, '{}' )", (Object)event.get("TX_ID"), (Object)name);
            FilterExpression f = FilterCompiler.parse("TX_ID @eq '" + name + "'");
            this.view.untag(f, name);
        }
    }

    public void delete(String txId) {
        if (txId == null) {
            return;
        }
        try {
            this.view.delete(txId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Long count(String filterString) throws Exception {
        block3: {
            log.info("Counting events by filter '{}'", (Object)filterString);
            try {
                if (this.view != null) {
                    FilterExpression filter = FilterCompiler.parse(filterString);
                    Long count = this.view.count(filter);
                    log.debug("  count is {}", (Object)count);
                    return count;
                }
                log.debug("View is 'null'!");
            }
            catch (Exception e) {
                log.error("Failed to count events: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
        return -1L;
    }

    public ScriptEvent get(String txId) throws Exception {
        E e = this.view.get(txId);
        if (e != null) {
            return new ScriptEvent((Event)e);
        }
        return null;
    }

    public Map<String, Long> count(String variable, String filter) {
        try {
            this.view.count(variable, FilterCompiler.parse(filter));
        }
        catch (Exception e) {
            return null;
        }
        return new HashMap<String, Long>();
    }
}

