/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.http.nio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CompressionHandler {
    public static int MAX_READAHEAD_BUFFER = 131072;

    public static byte[] gunzip(byte[] data) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        GZIPInputStream gz = new GZIPInputStream(in);
        return CompressionHandler.readUntilEOF(gz);
    }

    public static byte[] gzip(byte[] data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gz = new GZIPOutputStream(out);
        gz.write(data);
        gz.flush();
        gz.finish();
        out.flush();
        byte[] res = out.toByteArray();
        out.close();
        gz.close();
        return res;
    }

    public static byte[] readUntilEOF(InputStream in) throws IOException {
        byte[] data = new byte[MAX_READAHEAD_BUFFER];
        int i = 0;
        int c = 0;
        while (c != -1) {
            c = (byte)in.read();
            if (c != -1) {
                data[i++] = c;
            }
            if (i < MAX_READAHEAD_BUFFER) continue;
            throw new IOException("Read-a-head buffer to small!");
        }
        byte[] buf = new byte[i];
        int k = 0;
        while (k < buf.length) {
            buf[k] = data[k];
            ++k;
        }
        return buf;
    }

    public static void main(String[] args) {
        try {
            File f = new File(args[0]);
            boolean unzip = f.getAbsolutePath().endsWith(".gz");
            if (f.length() > Integer.MAX_VALUE) {
                throw new Exception("File " + f + " is larger than " + Integer.MAX_VALUE + " bytes!");
            }
            FileInputStream in = new FileInputStream(f);
            byte[] data = new byte[(int)f.length()];
            int read = in.read(data);
            if (read != data.length) {
                throw new Exception("Only read " + read + " bytes, expected to read: " + data.length);
            }
            byte[] buf = data;
            if (unzip) {
                System.out.println("gunzipped data to " + buf.length + " bytes.");
                buf = CompressionHandler.gunzip(data);
            } else {
                System.out.println("gzipped data to " + buf.length + " bytes.");
                buf = CompressionHandler.gzip(data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

