/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.http;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Set;
import org.jwall.web.http.HttpHeader;
import org.jwall.web.http.MessageFormatException;

public abstract class HttpMessage {
    protected String version = "";
    protected ByteBuffer body = ByteBuffer.allocate(0);
    protected HttpHeader header = null;

    public HttpMessage(HttpHeader mh, byte[] reqBody) throws MessageFormatException {
        this.header = mh;
        this.body = ByteBuffer.wrap(reqBody);
        this.parseStartLine(this.header.startLine);
    }

    protected abstract void parseStartLine(String var1) throws MessageFormatException;

    public Set<String> getHeaderNames() {
        return this.header.getHeaderNames();
    }

    public String getHeader() {
        return this.header.getHeader();
    }

    public String getHeader(String h) {
        if (HttpHeader.CASE_INSENSITIVE_HEADERS) {
            return this.header.getHeader(h.toLowerCase());
        }
        return this.header.getHeader(h.toLowerCase());
    }

    public HttpHeader getMessageHeader() {
        return this.header;
    }

    public ByteBuffer getBody() {
        return this.body;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public String getBodyAsString() {
        if (this.body == null || this.body.limit() == 0) {
            return "";
        }
        CharsetDecoder decoder = null;
        try {
            String enc = this.header.getHeader(HttpHeader.CONTENT_ENCODING);
            Charset cs = Charset.forName(enc);
            decoder = cs.newDecoder();
        }
        catch (Exception e) {
            decoder = Charset.defaultCharset().newDecoder();
        }
        try {
            CharBuffer cb = decoder.decode(this.body);
            return cb.toString();
        }
        catch (Exception e) {
            return this.body.asCharBuffer().toString();
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return String.valueOf(this.header.getHeader()) + "\r\n";
    }
}

