/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.List;
import java.util.Properties;
import org.jwall.web.audit.util.RFICollectorService;

public class RFIController {
    BufferedReader reader;
    Registry registry;
    boolean run = true;
    RFICollectorService server;
    Properties env = new Properties();

    public RFIController() throws Exception {
        this.reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Obtaining registry...");
        this.registry = LocateRegistry.getRegistry("127.0.0.1", 1099);
        System.out.println("Registry is " + this.registry);
        this.server = (RFICollectorService)this.registry.lookup("RFICollectorService");
        System.out.println("server = " + this.server);
        this.env.setProperty("org.jwall.rfi.download", "false");
        this.env.setProperty("org.jwall.rfi.data-dir", "/tmp");
        this.env.setProperty("org.jwall.rfi.site.dirs", "false");
        this.env.setProperty("org.jwall.rfi.files-only", "true");
    }

    public String eval(String line) throws Exception {
        String[] args;
        if (line.startsWith("list")) {
            StringBuffer s = new StringBuffer();
            List<String> c = this.server.listCollectors();
            for (String name : c) {
                s.append(String.valueOf(name) + "\n");
            }
            return s.toString();
        }
        if (line.startsWith("drop") && (args = line.split("\\s+")).length == 2) {
            this.server.unregisterCollector(args[1]);
            return "";
        }
        if (line.startsWith("create")) {
            args = line.split("\\s+");
            if (args.length == 2) {
                Properties p = new Properties();
                for (Object o : this.env.keySet()) {
                    p.setProperty(o.toString(), this.env.getProperty(o.toString()));
                }
                p.setProperty("org.jwall.rfi.log-file", args[1]);
                System.out.println("Creating collector for file " + p.getProperty("org.jwall.rfi.log-file"));
                this.server.registerCollector(args[1], p);
            } else {
                System.out.println("The \"create\" command needs exactly 2 parameters:");
                System.out.println("\taccess-log  -  the file to read from");
                System.out.println("\tproperties  -  a file to read the properties from.");
            }
        }
        if (line.startsWith("set")) {
            args = line.split("\\s+");
            if (args.length == 1) {
                StringBuffer s = new StringBuffer("Current environment:\n");
                for (Object o : this.env.keySet()) {
                    s.append("\t" + o.toString() + " = " + this.env.get(o) + "\n");
                }
                return s.toString();
            }
            if (args.length != 3) {
                return "Error: The \"set\" commands needs at least a variable-name and a value!";
            }
            String name = args[1];
            if (!name.startsWith("org.jwall.")) {
                name = "org.jwall." + name;
            }
            this.env.setProperty(name, args[2]);
        }
        if (line.startsWith("exit") || line.startsWith("quit")) {
            this.run = false;
        }
        return "";
    }

    public String readLine() throws Exception {
        return this.reader.readLine();
    }

    public void run() {
        try {
            String line = null;
            while (this.run) {
                System.out.print("#> ");
                line = this.readLine();
                if (line == null) continue;
                System.out.print(this.eval(line));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            RFIController ctrl = new RFIController();
            ctrl.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

