/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.rules.operators;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.jwall.web.audit.SyntaxException;
import org.jwall.web.audit.rules.Condition;
import org.jwall.web.audit.rules.operators.AbstractCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="LE")
public class ConditionLE
extends AbstractCondition {
    private static final long serialVersionUID = -6196215282881485160L;
    static Logger log = LoggerFactory.getLogger(ConditionLE.class);

    public ConditionLE(String variable, String value) throws SyntaxException {
        super(variable, value);
    }

    @Override
    public String getOperator() {
        return Condition.LE;
    }

    @Override
    public boolean matches(String pattern, String input) {
        if (ConditionLE.isNumeric(pattern)) {
            try {
                log.debug("Trying numeric comparison of pattern '{}' and input-value '{}'", (Object)pattern, (Object)input);
                return new Double(pattern).compareTo(new Double(input)) <= 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        log.debug("evaluating string-comparison of pattern '{}' and input-value '{}'", (Object)pattern, (Object)input);
        return pattern.compareTo(input) >= 0;
    }
}

