/*
 * Decompiled with CFR 0.152.
 */
package org.jwall.web.audit.net;

import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jwall.web.audit.AuditEvent;
import org.jwall.web.audit.AuditEventListener;
import org.jwall.web.audit.io.ConcurrentAuditWriter;
import org.jwall.web.audit.util.Base64Codec;
import org.jwall.web.audit.util.MD5;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditEventURLConnectionSender
implements AuditEventListener {
    public static final String CONSOLE_HOST = "org.modsecurity.console.host";
    public static final String CONSOLE_PORT = "org.modsecurity.console.port";
    public static final String CONSOLE_USER = "org.modsecurity.console.user";
    public static final String CONSOLE_PASS = "org.modsecurity.console.password";
    public static final String CONSOLE_CONNECTION_KEEP_ALIVE = "org.modsecurity.collector.keep-alive";
    private static Logger log = LoggerFactory.getLogger((String)"AuditEventConsoleSender");
    public static final String CONSOLE_URI = "/rpc/auditLogReceiver";
    private String host = "localhost";
    private int port = 8888;
    private String user = "";
    private String pass = "";
    private HttpURLConnection connection = null;

    public AuditEventURLConnectionSender(String host, int port, String login, String password) {
        this.host = host;
        this.port = port;
        this.user = login;
        this.pass = password;
        try {
            log.debug("Disabling certificate validation...");
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{new ZeroTrustManager()}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendAuditEvent(AuditEvent evt) throws Exception {
        byte[] data = evt.toString().getBytes();
        String hash = "md5:" + MD5.md5(data);
        String sum = ConcurrentAuditWriter.createSummary(evt);
        Base64Codec codec = new Base64Codec();
        String cred = new String(codec.encode((String.valueOf(this.user) + ":" + this.pass).getBytes()));
        HttpURLConnection con = this.getConnection();
        try {
            con.setRequestMethod("PUT");
            con.setRequestProperty("Authorization", cred);
            con.setRequestProperty("X-Content-Hash", hash);
            con.setRequestProperty("X-ForensicLog-Summary", sum);
            con.setRequestProperty("User-Agent", "jwall.org/Collector Version 0.2.17");
            String event = evt.toString();
            con.setFixedLengthStreamingMode(event.length());
            OutputStreamWriter out = new OutputStreamWriter(con.getOutputStream());
            out.write(event);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.connection = null;
            return;
        }
        log.info("ScriptEvent sent to server.");
        if (!con.getDoInput()) {
            this.connection = null;
            return;
        }
        con.getResponseMessage();
    }

    public HttpURLConnection getConnection() throws Exception {
        HttpURLConnection con;
        System.out.println("Establishing url connection...");
        URL url = new URL("http://" + this.host + ":" + this.port + CONSOLE_URI);
        this.connection = con = (HttpURLConnection)url.openConnection();
        this.connection.setInstanceFollowRedirects(false);
        this.connection.setRequestMethod("PUT");
        this.connection.setDoOutput(true);
        this.connection.setDoInput(true);
        this.connection.setUseCaches(false);
        this.connection.setAllowUserInteraction(false);
        return this.connection;
    }

    @Override
    public void eventArrived(AuditEvent evt) {
        try {
            this.sendAuditEvent(evt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void eventsArrived(Collection<AuditEvent> events) {
        for (AuditEvent evt : events) {
            this.eventArrived(evt);
        }
    }

    public class ZeroTrustManager
    implements X509TrustManager,
    TrustManager {
        private Logger log = LoggerFactory.getLogger((String)"ZeroTrustManager");

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.log.debug("checkClientTrusted: \n");
            X509Certificate[] x509CertificateArray = chain;
            int n = chain.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate cert = x509CertificateArray[n2];
                this.log.debug("-------------------------------------------------------");
                this.log.debug(" SubjectDN = " + cert.getSubjectDN());
                this.log.debug(" Issuer = " + cert.getIssuerDN());
                ++n2;
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.log.debug("checkServerTrusted: \n");
            X509Certificate[] x509CertificateArray = chain;
            int n = chain.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate cert = x509CertificateArray[n2];
                this.log.debug("-------------------------------------------------------");
                this.log.debug(" SubjectDN = " + cert.getSubjectDN());
                this.log.debug(" Issuer = " + cert.getIssuerDN());
                ++n2;
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

